/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.data.message;

import dev.langchain4j.data.image.Image;
import dev.langchain4j.data.message.ContentType;
import dev.langchain4j.data.message.ImageContent;
import java.net.URI;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.WithAssertions;
import org.junit.jupiter.api.Test;

class ImageContentTest
implements WithAssertions {
    ImageContentTest() {
    }

    @Test
    void methods() {
        Image urlImage = Image.builder().url(URI.create("https://example.com/image.png")).build();
        ImageContent imageContent = new ImageContent(urlImage, ImageContent.DetailLevel.HIGH);
        this.assertThat(imageContent.image()).isEqualTo((Object)urlImage);
        this.assertThat((Comparable)imageContent.detailLevel()).isEqualTo((Object)ImageContent.DetailLevel.HIGH);
        this.assertThat((Comparable)imageContent.type()).isEqualTo((Object)ContentType.IMAGE);
        this.assertThat(imageContent).hasToString("ImageContent { image = Image { url = \"https://example.com/image.png\", base64Data = null, mimeType = null, revisedPrompt = null } detailLevel = HIGH }");
    }

    @Test
    void equals_hash_code() {
        ImageContent i1 = ImageContent.from((String)"https://example.com/image.png");
        ImageContent i2 = ImageContent.from((String)"https://example.com/image.png");
        ImageContent i3 = ImageContent.from((String)"https://example.com/image.jpg");
        ImageContent i4 = ImageContent.from((String)"https://example.com/image.jpg");
        ((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)this.assertThat(i1).isEqualTo((Object)i1)).isNotEqualTo(null)).isNotEqualTo(new Object())).isEqualTo((Object)i2)).hasSameHashCodeAs((Object)i2)).isNotEqualTo((Object)i3)).isNotEqualTo((Object)i4);
        ((ObjectAssert)((ObjectAssert)this.assertThat(i3).isEqualTo((Object)i3)).isEqualTo((Object)i4)).hasSameHashCodeAs((Object)i4);
    }

    @Test
    void builders() {
        Image urlImage = Image.builder().url(URI.create("https://example.com/image.png")).build();
        ((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)this.assertThat(new ImageContent(urlImage, ImageContent.DetailLevel.LOW)).isEqualTo((Object)new ImageContent(urlImage))).isEqualTo((Object)ImageContent.from((Image)urlImage, (ImageContent.DetailLevel)ImageContent.DetailLevel.LOW))).isEqualTo((Object)ImageContent.from((Image)urlImage))).isEqualTo((Object)new ImageContent(urlImage.url()))).isEqualTo((Object)new ImageContent(urlImage.url().toString()))).isEqualTo((Object)new ImageContent(urlImage.url(), ImageContent.DetailLevel.LOW))).isEqualTo((Object)new ImageContent(urlImage.url().toString(), ImageContent.DetailLevel.LOW))).isEqualTo((Object)ImageContent.from((URI)urlImage.url()))).isEqualTo((Object)ImageContent.from((String)urlImage.url().toString()))).isEqualTo((Object)ImageContent.from((URI)urlImage.url(), (ImageContent.DetailLevel)ImageContent.DetailLevel.LOW))).isEqualTo((Object)ImageContent.from((String)urlImage.url().toString(), (ImageContent.DetailLevel)ImageContent.DetailLevel.LOW));
        Image base64Image = Image.builder().base64Data("ff==").mimeType("mimeType").build();
        ((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)this.assertThat(new ImageContent(base64Image, ImageContent.DetailLevel.LOW)).isEqualTo((Object)new ImageContent(base64Image))).isEqualTo((Object)ImageContent.from((Image)base64Image, (ImageContent.DetailLevel)ImageContent.DetailLevel.LOW))).isEqualTo((Object)ImageContent.from((Image)base64Image))).isEqualTo((Object)new ImageContent(base64Image.base64Data(), base64Image.mimeType()))).isEqualTo((Object)new ImageContent(base64Image.base64Data(), base64Image.mimeType(), ImageContent.DetailLevel.LOW))).isEqualTo((Object)ImageContent.from((String)base64Image.base64Data(), (String)base64Image.mimeType()))).isEqualTo((Object)ImageContent.from((String)base64Image.base64Data(), (String)base64Image.mimeType(), (ImageContent.DetailLevel)ImageContent.DetailLevel.LOW));
    }
}

