/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.data.document;

import dev.langchain4j.data.document.Document;
import dev.langchain4j.data.document.Metadata;
import dev.langchain4j.data.segment.TextSegment;
import java.util.HashMap;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.WithAssertions;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.NullSource;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.Mockito;

class DocumentTest
implements WithAssertions {
    DocumentTest() {
    }

    @Test
    void equals_hash_code() {
        Document document1 = Document.from((String)"foo bar");
        Document document2 = Document.from((String)"foo bar");
        Document document3 = Document.from((String)"foo bar", (Metadata)Metadata.from((String)"foo", (String)"bar"));
        Document document4 = Document.from((String)"foo bar", (Metadata)Metadata.from((String)"foo", (String)"bar"));
        ((ObjectAssert)this.assertThat(document1).isEqualTo((Object)document2)).hasSameHashCodeAs((Object)document2);
        ((ObjectAssert)this.assertThat(document1).isNotEqualTo((Object)document3)).doesNotHaveSameHashCodeAs((Object)document3);
        ((ObjectAssert)this.assertThat(document3).isEqualTo((Object)document4)).hasSameHashCodeAs((Object)document4);
    }

    @Test
    void no_metadata() {
        Document document = Document.from((String)"foo bar");
        this.assertThat(document.text()).isEqualTo("foo bar");
        this.assertThat(document.metadata().toMap()).isEmpty();
        this.assertThat(document).hasToString("DefaultDocument { text = \"foo bar\", metadata = Metadata { metadata = {} } }");
        HashMap<String, String> expectedMetadata = new HashMap<String, String>();
        expectedMetadata.put("index", "0");
        this.assertThat(document.toTextSegment()).isEqualTo((Object)new TextSegment("foo bar", Metadata.from(expectedMetadata)));
    }

    @Test
    void with_metadata() {
        Document document = Document.from((String)"foo bar", (Metadata)Metadata.from((String)"foo", (String)"bar"));
        this.assertThat(document.text()).isEqualTo("foo bar");
        this.assertThat(document.metadata().toMap()).hasSize(1);
        this.assertThat(document.metadata().getString("foo")).isEqualTo("bar");
        this.assertThat(document).hasToString("DefaultDocument { text = \"foo bar\", metadata = Metadata { metadata = {foo=bar} } }");
        HashMap<String, String> expectedMetadata = new HashMap<String, String>();
        expectedMetadata.put("index", "0");
        expectedMetadata.put("foo", "bar");
        this.assertThat(document.toTextSegment()).isEqualTo((Object)new TextSegment("foo bar", Metadata.from(expectedMetadata)));
    }

    @Test
    void from() {
        this.assertThat(Document.from((String)"foo bar")).isEqualTo((Object)Document.from((String)"foo bar", (Metadata)new Metadata()));
        this.assertThat(Document.from((String)"foo bar", (Metadata)Metadata.from((String)"foo", (String)"bar"))).isEqualTo((Object)Document.from((String)"foo bar", (Metadata)Metadata.from((String)"foo", (String)"bar")));
        this.assertThat(Document.document((String)"foo bar")).isEqualTo((Object)Document.from((String)"foo bar", (Metadata)new Metadata()));
        this.assertThat(Document.document((String)"foo bar", (Metadata)Metadata.from((String)"foo", (String)"bar"))).isEqualTo((Object)Document.from((String)"foo bar", (Metadata)Metadata.from((String)"foo", (String)"bar")));
    }

    @ParameterizedTest(name="{index}: \"{arguments}\"")
    @ValueSource(strings={"", " ", "\t"})
    @NullSource
    void constructor_should_fail_on_empty_text(String text) {
        IllegalArgumentException exception = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Document.from((String)text));
        this.assertThat(exception).hasMessage("text cannot be null or blank");
        IllegalArgumentException exception2 = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Document.from((String)text, (Metadata)((Metadata)Mockito.mock(Metadata.class))));
        this.assertThat(exception2).hasMessage("text cannot be null or blank");
    }

    @Test
    void constructor_should_fail_on_empty_metadata() {
        IllegalArgumentException exception = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Document.from((String)"ok", null));
        this.assertThat(exception).hasMessage("metadata cannot be null");
    }
}

