/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.data.document;

import dev.langchain4j.data.document.Document;
import dev.langchain4j.data.document.DocumentSplitter;
import dev.langchain4j.data.document.Metadata;
import dev.langchain4j.data.segment.TextSegment;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.assertj.core.api.WithAssertions;
import org.junit.jupiter.api.Test;

class DocumentSplitterTest
implements WithAssertions {
    DocumentSplitterTest() {
    }

    @Test
    void split_all() {
        ArrayList<Document> docs = new ArrayList<Document>();
        docs.add(Document.document((String)"abc def"));
        docs.add(Document.document((String)"abc def", (Metadata)Metadata.metadata((String)"foo", (String)"bar")));
        WhitespaceSplitter splitter = new WhitespaceSplitter();
        this.assertThat(splitter.splitAll(docs)).containsExactly((Object[])new TextSegment[]{new TextSegment("abc", new Metadata()), new TextSegment("def", new Metadata()), new TextSegment("abc", Metadata.metadata((String)"foo", (String)"bar")), new TextSegment("def", Metadata.metadata((String)"foo", (String)"bar"))});
    }

    public static final class WhitespaceSplitter
    implements DocumentSplitter {
        public List<TextSegment> split(Document document) {
            Metadata metadata = document.metadata();
            return Arrays.stream(document.text().split("\\s+")).filter(s -> !s.isEmpty()).map(s -> new TextSegment(s, metadata.copy())).collect(Collectors.toList());
        }
    }
}

