/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.chat;

import dev.langchain4j.Experimental;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.model.chat.Capability;
import dev.langchain4j.model.chat.request.ChatRequest;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.output.Response;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public interface ChatLanguageModel {
    default public String generate(String userMessage) {
        return this.generate(UserMessage.from(userMessage)).content().text();
    }

    default public Response<AiMessage> generate(ChatMessage ... messages) {
        return this.generate(Arrays.asList(messages));
    }

    public Response<AiMessage> generate(List<ChatMessage> var1);

    default public Response<AiMessage> generate(List<ChatMessage> messages, List<ToolSpecification> toolSpecifications) {
        throw new IllegalArgumentException("Tools are currently not supported by this model");
    }

    default public Response<AiMessage> generate(List<ChatMessage> messages, ToolSpecification toolSpecification) {
        throw new IllegalArgumentException("Tools are currently not supported by this model");
    }

    @Experimental
    default public ChatResponse chat(ChatRequest request) {
        throw new UnsupportedOperationException();
    }

    @Experimental
    default public Set<Capability> supportedCapabilities() {
        return Collections.emptySet();
    }
}

