/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.web.search;

import dev.langchain4j.web.search.WebSearchEngine;
import dev.langchain4j.web.search.WebSearchInformationResult;
import dev.langchain4j.web.search.WebSearchOrganicResult;
import dev.langchain4j.web.search.WebSearchResults;
import dev.langchain4j.web.search.WebSearchTool;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

class WebSearchToolTest {
    WebSearchEngine webSearchEngine;

    WebSearchToolTest() {
    }

    @BeforeEach
    void mockWebSearchEngine() {
        this.webSearchEngine = (WebSearchEngine)Mockito.mock(WebSearchEngine.class);
        Mockito.when((Object)this.webSearchEngine.search(ArgumentMatchers.anyString())).thenReturn((Object)new WebSearchResults(WebSearchInformationResult.from((Long)3L, (Integer)1, new HashMap()), Arrays.asList(WebSearchOrganicResult.from((String)"title 1", (URI)URI.create("https://google.com"), (String)"snippet 1", (String)"content 1"), WebSearchOrganicResult.from((String)"title 2", (URI)URI.create("https://docs.langchain4j.dev"), (String)"snippet 2", (String)"content 2"), WebSearchOrganicResult.from((String)"title 3", (URI)URI.create("https://github.com/dewitt/opensearch/blob/master/README.md"), (String)"snippet 3", (String)"content 3"))));
    }

    @AfterEach
    void resetWebSearchEngine() {
        Mockito.reset((Object[])new WebSearchEngine[]{this.webSearchEngine});
    }

    @Test
    void should_build_webSearchTool() {
        String searchTerm = "Any text to search";
        WebSearchTool webSearchTool = WebSearchTool.from((WebSearchEngine)this.webSearchEngine);
        String strResult = webSearchTool.searchWeb(searchTerm);
        Assertions.assertThat((String)strResult).isNotBlank();
        ((AbstractStringAssert)Assertions.assertThat((String)strResult).as("At least one result should be contains 'title 1' and 'https://google.com' and 'content 1'", new Object[0])).contains(new CharSequence[]{"Title: title 1\nSource: https://google.com\nContent:\ncontent 1"});
        ((WebSearchEngine)Mockito.verify((Object)this.webSearchEngine)).search(searchTerm);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.webSearchEngine});
    }
}

