/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.store.embedding;

import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.store.embedding.CosineSimilarity;
import org.assertj.core.api.WithAssertions;
import org.assertj.core.data.Percentage;
import org.junit.jupiter.api.Test;

class CosineSimilarityTest
implements WithAssertions {
    CosineSimilarityTest() {
    }

    @Test
    public void test_bad() {
        Embedding embeddingA = Embedding.from((float[])new float[]{1.0f, 1.0f, 1.0f});
        Embedding embeddingB = Embedding.from((float[])new float[]{1.0f, 1.0f, 1.0f, 1.0f});
        this.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> CosineSimilarity.between((Embedding)embeddingA, (Embedding)embeddingB)).withMessage("Length of vector a (3) must be equal to the length of vector b (4)");
    }

    @Test
    public void test_zeros() {
        Embedding embeddingA = Embedding.from((float[])new float[]{0.0f, 0.0f, 0.0f});
        Embedding embeddingB = Embedding.from((float[])new float[]{0.0f, 0.0f, 0.0f});
        this.assertThat(CosineSimilarity.between((Embedding)embeddingA, (Embedding)embeddingB)).isCloseTo(0.0, Percentage.withPercentage((double)1.0));
    }

    @Test
    void should_calculate_cosine_similarity() {
        Embedding embeddingA = Embedding.from((float[])new float[]{1.0f, -1.0f, 1.0f});
        Embedding embeddingB = Embedding.from((float[])new float[]{-1.0f, 1.0f, -1.0f});
        this.assertThat(CosineSimilarity.between((Embedding)embeddingA, (Embedding)embeddingA)).isCloseTo(1.0, Percentage.withPercentage((double)1.0));
        this.assertThat(CosineSimilarity.between((Embedding)embeddingA, (Embedding)embeddingB)).isCloseTo(-1.0, Percentage.withPercentage((double)1.0));
    }

    @Test
    void should_convert_relevance_score_into_cosine_similarity() {
        this.assertThat(CosineSimilarity.fromRelevanceScore((double)0.0)).isEqualTo(-1.0);
        this.assertThat(CosineSimilarity.fromRelevanceScore((double)0.5)).isEqualTo(0.0);
        this.assertThat(CosineSimilarity.fromRelevanceScore((double)1.0)).isEqualTo(1.0);
    }
}

