/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.output;

import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.TokenUsage;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.WithAssertions;
import org.junit.jupiter.api.Test;

class ResponseTest
implements WithAssertions {
    ResponseTest() {
    }

    @Test
    public void test_methods() {
        Response response = new Response((Object)"content");
        this.assertThat((String)response.content()).isEqualTo("content");
        this.assertThat(response.tokenUsage()).isNull();
        this.assertThat((Comparable)response.finishReason()).isNull();
        this.assertThat(response).hasToString("Response { content = content, tokenUsage = null, finishReason = null }");
        TokenUsage tokenUsage = new TokenUsage(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3));
        Response response2 = new Response((Object)"content", tokenUsage, null);
        this.assertThat((String)response2.content()).isEqualTo("content");
        this.assertThat(response2.tokenUsage()).isEqualTo((Object)tokenUsage);
        this.assertThat((Comparable)response2.finishReason()).isNull();
        this.assertThat(response2).hasToString("Response { content = content, tokenUsage = TokenUsage { inputTokenCount = 1, outputTokenCount = 2, totalTokenCount = 3 }, finishReason = null }");
        tokenUsage = new TokenUsage(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3));
        response2 = new Response((Object)"content", tokenUsage, FinishReason.LENGTH);
        this.assertThat((String)response2.content()).isEqualTo("content");
        this.assertThat(response2.tokenUsage()).isEqualTo((Object)tokenUsage);
        this.assertThat((Comparable)response2.finishReason()).isEqualTo((Object)FinishReason.LENGTH);
        this.assertThat(response2).hasToString("Response { content = content, tokenUsage = TokenUsage { inputTokenCount = 1, outputTokenCount = 2, totalTokenCount = 3 }, finishReason = LENGTH }");
    }

    @Test
    public void test_equals_hashCode() {
        String content1 = "content";
        String content2 = "changed";
        TokenUsage tokenUsage1 = new TokenUsage(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3));
        TokenUsage tokenUsage2 = new TokenUsage(Integer.valueOf(10), Integer.valueOf(2), Integer.valueOf(3));
        ((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)this.assertThat(new Response((Object)content1, null, null)).isEqualTo((Object)new Response((Object)content1, null, null))).hasSameHashCodeAs((Object)new Response((Object)content1, null, null))).isNotEqualTo(null)).isNotEqualTo(new Object())).isNotEqualTo((Object)new Response((Object)content2, null, null))).doesNotHaveSameHashCodeAs((Object)new Response((Object)content2, null, null))).isNotEqualTo((Object)new Response((Object)content1, tokenUsage1, null))).doesNotHaveSameHashCodeAs((Object)new Response((Object)content1, tokenUsage1, null))).isNotEqualTo((Object)new Response((Object)content1, null, FinishReason.LENGTH))).doesNotHaveSameHashCodeAs((Object)new Response((Object)content1, null, FinishReason.LENGTH))).isNotEqualTo((Object)new Response((Object)content1, tokenUsage1, FinishReason.LENGTH))).doesNotHaveSameHashCodeAs((Object)new Response((Object)content1, tokenUsage1, FinishReason.LENGTH));
        ((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)this.assertThat(new Response((Object)content1, tokenUsage1, FinishReason.LENGTH)).isEqualTo((Object)new Response((Object)content1, tokenUsage1, FinishReason.LENGTH))).hasSameHashCodeAs((Object)new Response((Object)content1, tokenUsage1, FinishReason.LENGTH))).isNotEqualTo((Object)new Response((Object)content2, tokenUsage1, FinishReason.LENGTH))).isNotEqualTo((Object)new Response((Object)content1, tokenUsage2, FinishReason.LENGTH))).isNotEqualTo((Object)new Response((Object)content1, tokenUsage1, FinishReason.STOP));
    }

    @Test
    public void test_builders() {
        this.assertThat(new Response((Object)"content")).isEqualTo((Object)Response.from((Object)"content"));
        TokenUsage tokenUsage = new TokenUsage(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3));
        ((ObjectAssert)this.assertThat(new Response((Object)"content", tokenUsage, null)).isEqualTo((Object)Response.from((Object)"content", (TokenUsage)tokenUsage))).isEqualTo((Object)Response.from((Object)"content", (TokenUsage)tokenUsage, null));
        this.assertThat(new Response((Object)"content", tokenUsage, FinishReason.LENGTH)).isEqualTo((Object)Response.from((Object)"content", (TokenUsage)tokenUsage, (FinishReason)FinishReason.LENGTH));
    }
}

