/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model;

import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.model.LambdaStreamingResponseHandler;
import dev.langchain4j.model.StreamingResponseHandler;
import dev.langchain4j.model.chat.StreamingChatLanguageModel;
import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.WithAssertions;
import org.junit.jupiter.api.Test;

public class LambdaStreamingResponseHandlerTest
implements WithAssertions {
    @Test
    void testOnNext() {
        ArrayList<String> tokens = new ArrayList<String>();
        tokens.add("The sky ");
        tokens.add("is blue because of ");
        tokens.add("a phenomenon called ");
        tokens.add("Rayleigh scattering.");
        DummyModel model = new DummyModel(tokens);
        ArrayList receivedTokens = new ArrayList();
        model.generate("Why is the sky blue?", LambdaStreamingResponseHandler.onNext(text -> receivedTokens.add(text)));
        this.assertThat(receivedTokens).containsSequence(tokens);
    }

    @Test
    void testOnNextAndError() {
        ArrayList<Object> tokens = new ArrayList<Object>();
        tokens.add("Three ");
        tokens.add("Two ");
        tokens.add("One ");
        tokens.add(new RuntimeException("BOOM"));
        DummyModel model = new DummyModel(tokens);
        ArrayList receivedTokens = new ArrayList();
        Throwable[] thrown = new Throwable[]{null};
        model.generate("Create a countdown", LambdaStreamingResponseHandler.onNextAndError(text -> receivedTokens.add(text), t -> {
            thrown[0] = t;
        }));
        this.assertThat(tokens).containsSubsequence(receivedTokens);
        this.assertThat(thrown[0]).isNotNull();
        this.assertThat(thrown[0]).isInstanceOf(RuntimeException.class);
        this.assertThat(thrown[0].getMessage()).isEqualTo("BOOM");
    }

    class DummyModel
    implements StreamingChatLanguageModel {
        private final List stringsAndError;

        public DummyModel(List stringsAndError) {
            this.stringsAndError = stringsAndError;
        }

        public void generate(String userMessage, StreamingResponseHandler<AiMessage> handler) {
            super.generate(userMessage, handler);
        }

        public void generate(UserMessage userMessage, StreamingResponseHandler<AiMessage> handler) {
            super.generate(userMessage, handler);
        }

        public void generate(List<ChatMessage> messages, StreamingResponseHandler<AiMessage> handler) {
            this.stringsAndError.forEach(obj -> {
                if (obj instanceof String) {
                    String msg = (String)obj;
                    handler.onNext(msg);
                } else if (obj instanceof Throwable) {
                    Throwable problem = (Throwable)obj;
                    handler.onError(problem);
                }
            });
        }

        public void generate(List<ChatMessage> messages, List<ToolSpecification> toolSpecifications, StreamingResponseHandler<AiMessage> handler) {
            super.generate(messages, toolSpecifications, handler);
        }

        public void generate(List<ChatMessage> messages, ToolSpecification toolSpecification, StreamingResponseHandler<AiMessage> handler) {
            super.generate(messages, toolSpecification, handler);
        }
    }
}

