/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.data.embedding;

import dev.langchain4j.data.embedding.Embedding;
import java.util.ArrayList;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.WithAssertions;
import org.junit.jupiter.api.Test;

class EmbeddingTest
implements WithAssertions {
    EmbeddingTest() {
    }

    @Test
    public void test_equals_hash() {
        Embedding e1 = new Embedding(new float[]{1.0f, 2.0f, 3.0f});
        Embedding e2 = new Embedding(new float[]{1.0f, 2.0f, 3.0f});
        ((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)this.assertThat(e1).isEqualTo((Object)e1)).isNotEqualTo(null)).isNotEqualTo(new Object())).isEqualTo((Object)e2)).hasSameHashCodeAs((Object)e2);
        this.assertThat(new Embedding(new float[]{99.0f, 2.0f, 3.0f})).isNotEqualTo((Object)e1);
        this.assertThat(new Embedding(new float[]{1.0f, 2.0f, 3.0f, 4.0f})).isNotEqualTo((Object)e1);
    }

    @Test
    public void test_accessors() {
        Embedding e1 = new Embedding(new float[]{1.0f, 2.0f, 3.0f});
        this.assertThat(e1.dimension()).isEqualTo(3);
        this.assertThat(e1.vector()).containsExactly(new float[]{1.0f, 2.0f, 3.0f});
        this.assertThat(e1.vectorAsList()).containsExactly((Object[])new Float[]{Float.valueOf(1.0f), Float.valueOf(2.0f), Float.valueOf(3.0f)});
        this.assertThat(e1).hasToString("Embedding { vector = [1.0, 2.0, 3.0] }");
    }

    @Test
    public void test_from() {
        this.assertThat(Embedding.from((float[])new float[]{1.0f, 2.0f, 3.0f})).isEqualTo((Object)new Embedding(new float[]{1.0f, 2.0f, 3.0f}));
        ArrayList<Float> list = new ArrayList<Float>();
        list.add(Float.valueOf(1.0f));
        list.add(Float.valueOf(2.0f));
        list.add(Float.valueOf(3.0f));
        this.assertThat(Embedding.from(list)).isEqualTo((Object)new Embedding(new float[]{1.0f, 2.0f, 3.0f}));
    }

    @Test
    void test_normalize() {
        Embedding embedding = new Embedding(new float[]{6.0f, 8.0f});
        embedding.normalize();
        Embedding expect = new Embedding(new float[]{0.6f, 0.8f});
        this.assertThat(embedding).isEqualTo((Object)expect);
    }
}

