/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.data.document;

import dev.langchain4j.data.document.Document;
import dev.langchain4j.data.document.Metadata;
import dev.langchain4j.data.segment.TextSegment;
import java.util.HashMap;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.WithAssertions;
import org.junit.jupiter.api.Test;

class DocumentTest
implements WithAssertions {
    DocumentTest() {
    }

    @Test
    public void test_equals_hashCode() {
        Document document1 = Document.from((String)"foo bar");
        Document document2 = Document.from((String)"foo bar");
        Document document3 = Document.from((String)"foo bar", (Metadata)Metadata.from((String)"foo", (String)"bar"));
        Document document4 = Document.from((String)"foo bar", (Metadata)Metadata.from((String)"foo", (String)"bar"));
        ((ObjectAssert)this.assertThat(document1).isEqualTo((Object)document2)).hasSameHashCodeAs((Object)document2);
        ((ObjectAssert)this.assertThat(document1).isNotEqualTo((Object)document3)).doesNotHaveSameHashCodeAs((Object)document3);
        ((ObjectAssert)this.assertThat(document3).isEqualTo((Object)document4)).hasSameHashCodeAs((Object)document4);
    }

    @Test
    public void test_noMetadata() {
        Document document = Document.from((String)"foo bar");
        this.assertThat(document.text()).isEqualTo("foo bar");
        this.assertThat(document.metadata().asMap().isEmpty()).isTrue();
        this.assertThat(document).hasToString("Document { text = \"foo bar\" metadata = {} }");
        HashMap<String, String> expectedMetadata = new HashMap<String, String>();
        expectedMetadata.put("index", "0");
        this.assertThat(document.toTextSegment()).isEqualTo((Object)new TextSegment("foo bar", new Metadata(expectedMetadata)));
    }

    @Test
    public void test_withMetadata() {
        Document document = Document.from((String)"foo bar", (Metadata)Metadata.from((String)"foo", (String)"bar"));
        this.assertThat(document.text()).isEqualTo("foo bar");
        this.assertThat(document.metadata().asMap()).hasSize(1);
        this.assertThat(document.metadata("foo")).isEqualTo("bar");
        this.assertThat(document).hasToString("Document { text = \"foo bar\" metadata = {foo=bar} }");
        HashMap<String, String> expectedMetadata = new HashMap<String, String>();
        expectedMetadata.put("index", "0");
        expectedMetadata.put("foo", "bar");
        this.assertThat(document.toTextSegment()).isEqualTo((Object)new TextSegment("foo bar", new Metadata(expectedMetadata)));
    }

    @Test
    public void test_from() {
        this.assertThat(Document.from((String)"foo bar")).isEqualTo((Object)new Document("foo bar", new Metadata()));
        this.assertThat(Document.from((String)"foo bar", (Metadata)Metadata.from((String)"foo", (String)"bar"))).isEqualTo((Object)new Document("foo bar", Metadata.from((String)"foo", (String)"bar")));
        this.assertThat(Document.document((String)"foo bar")).isEqualTo((Object)new Document("foo bar", new Metadata()));
        this.assertThat(Document.document((String)"foo bar", (Metadata)Metadata.from((String)"foo", (String)"bar"))).isEqualTo((Object)new Document("foo bar", Metadata.from((String)"foo", (String)"bar")));
    }
}

