/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.output;

import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.TokenUsage;
import java.util.Objects;

public class Response<T> {
    private final T content;
    private final TokenUsage tokenUsage;
    private final FinishReason finishReason;

    public Response(T content) {
        this(content, null, null);
    }

    public Response(T content, TokenUsage tokenUsage, FinishReason finishReason) {
        this.content = ValidationUtils.ensureNotNull(content, "content");
        this.tokenUsage = tokenUsage;
        this.finishReason = finishReason;
    }

    public T content() {
        return this.content;
    }

    public TokenUsage tokenUsage() {
        return this.tokenUsage;
    }

    public FinishReason finishReason() {
        return this.finishReason;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Response that = (Response)o;
        return Objects.equals(this.content, that.content) && Objects.equals(this.tokenUsage, that.tokenUsage) && Objects.equals((Object)this.finishReason, (Object)that.finishReason);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.content, this.tokenUsage, this.finishReason});
    }

    public String toString() {
        return "Response { content = " + this.content + ", tokenUsage = " + this.tokenUsage + ", finishReason = " + (Object)((Object)this.finishReason) + " }";
    }

    public static <T> Response<T> from(T content) {
        return new Response<T>(content);
    }

    public static <T> Response<T> from(T content, TokenUsage tokenUsage) {
        return new Response<T>(content, tokenUsage, null);
    }

    public static <T> Response<T> from(T content, TokenUsage tokenUsage, FinishReason finishReason) {
        return new Response<T>(content, tokenUsage, finishReason);
    }
}

