/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.data.document;

import dev.langchain4j.data.document.Metadata;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import java.util.Objects;

public class Document {
    public static final String FILE_NAME = "file_name";
    public static final String ABSOLUTE_DIRECTORY_PATH = "absolute_directory_path";
    public static final String URL = "url";
    private final String text;
    private final Metadata metadata;

    public Document(String text) {
        this(text, new Metadata());
    }

    public Document(String text, Metadata metadata) {
        this.text = ValidationUtils.ensureNotBlank(text, "text");
        this.metadata = ValidationUtils.ensureNotNull(metadata, "metadata");
    }

    public String text() {
        return this.text;
    }

    public Metadata metadata() {
        return this.metadata;
    }

    @Deprecated
    public String metadata(String key) {
        return this.metadata.get(key);
    }

    public TextSegment toTextSegment() {
        return TextSegment.from(this.text, this.metadata.copy().add("index", "0"));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Document that = (Document)o;
        return Objects.equals(this.text, that.text) && Objects.equals(this.metadata, that.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.text, this.metadata);
    }

    public String toString() {
        return "Document { text = " + Utils.quoted(this.text) + " metadata = " + this.metadata.asMap() + " }";
    }

    public static Document from(String text) {
        return new Document(text);
    }

    public static Document from(String text, Metadata metadata) {
        return new Document(text, metadata);
    }

    public static Document document(String text) {
        return Document.from(text);
    }

    public static Document document(String text, Metadata metadata) {
        return Document.from(text, metadata);
    }
}

