/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.data.message;

import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.ChatMessageType;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class AiMessage
implements ChatMessage {
    private final String text;
    private final List<ToolExecutionRequest> toolExecutionRequests;

    public AiMessage(String text) {
        this.text = ValidationUtils.ensureNotBlank(text, "text");
        this.toolExecutionRequests = null;
    }

    public AiMessage(List<ToolExecutionRequest> toolExecutionRequests) {
        this.text = null;
        this.toolExecutionRequests = ValidationUtils.ensureNotEmpty(toolExecutionRequests, "toolExecutionRequests");
    }

    @Override
    public String text() {
        return this.text;
    }

    public List<ToolExecutionRequest> toolExecutionRequests() {
        return this.toolExecutionRequests;
    }

    public boolean hasToolExecutionRequests() {
        return !Utils.isNullOrEmpty(this.toolExecutionRequests);
    }

    @Override
    public ChatMessageType type() {
        return ChatMessageType.AI;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AiMessage that = (AiMessage)o;
        return Objects.equals(this.text, that.text) && Objects.equals(this.toolExecutionRequests, that.toolExecutionRequests);
    }

    public int hashCode() {
        return Objects.hash(this.text, this.toolExecutionRequests);
    }

    public String toString() {
        return "AiMessage { text = " + Utils.quoted(this.text) + " toolExecutionRequests = " + this.toolExecutionRequests + " }";
    }

    public static AiMessage from(String text) {
        return new AiMessage(text);
    }

    public static AiMessage from(ToolExecutionRequest ... toolExecutionRequests) {
        return AiMessage.from(Arrays.asList(toolExecutionRequests));
    }

    public static AiMessage from(List<ToolExecutionRequest> toolExecutionRequests) {
        return new AiMessage(toolExecutionRequests);
    }

    public static AiMessage aiMessage(String text) {
        return AiMessage.from(text);
    }

    public static AiMessage aiMessage(ToolExecutionRequest ... toolExecutionRequests) {
        return AiMessage.aiMessage(Arrays.asList(toolExecutionRequests));
    }

    public static AiMessage aiMessage(List<ToolExecutionRequest> toolExecutionRequests) {
        return AiMessage.from(toolExecutionRequests);
    }
}

