/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.internal;

import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryUtils {
    private static final Logger log = LoggerFactory.getLogger(RetryUtils.class);

    public static <T> T withRetry(Callable<T> action, int maxAttempts) {
        for (int attempt = 1; attempt <= maxAttempts; ++attempt) {
            try {
                return action.call();
            }
            catch (Exception e) {
                if (attempt == maxAttempts) {
                    throw new RuntimeException(e);
                }
                log.warn(String.format("Exception was thrown on attempt %s of %s", attempt, maxAttempts), (Throwable)e);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
        }
        throw new RuntimeException("Failed after " + maxAttempts + " attempts");
    }
}

