/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.community.model.dashscope;

import com.alibaba.dashscope.aigc.conversation.ConversationParam;
import com.alibaba.dashscope.aigc.generation.GenerationOutput;
import com.alibaba.dashscope.aigc.generation.GenerationParam;
import com.alibaba.dashscope.aigc.generation.GenerationResult;
import com.alibaba.dashscope.aigc.generation.SearchInfo;
import com.alibaba.dashscope.aigc.generation.SearchOptions;
import com.alibaba.dashscope.aigc.multimodalconversation.MultiModalConversationOutput;
import com.alibaba.dashscope.aigc.multimodalconversation.MultiModalConversationParam;
import com.alibaba.dashscope.aigc.multimodalconversation.MultiModalConversationResult;
import com.alibaba.dashscope.common.Message;
import com.alibaba.dashscope.common.MultiModalMessage;
import com.alibaba.dashscope.common.ResponseFormat;
import com.alibaba.dashscope.common.Role;
import com.alibaba.dashscope.tools.FunctionDefinition;
import com.alibaba.dashscope.tools.ToolBase;
import com.alibaba.dashscope.tools.ToolCallBase;
import com.alibaba.dashscope.tools.ToolCallFunction;
import com.alibaba.dashscope.tools.ToolFunction;
import com.alibaba.dashscope.utils.JsonUtils;
import com.google.gson.JsonObject;
import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.community.model.dashscope.QwenChatRequestParameters;
import dev.langchain4j.community.model.dashscope.QwenChatResponseMetadata;
import dev.langchain4j.data.audio.Audio;
import dev.langchain4j.data.image.Image;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.AudioContent;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.ChatMessageType;
import dev.langchain4j.data.message.Content;
import dev.langchain4j.data.message.ImageContent;
import dev.langchain4j.data.message.SystemMessage;
import dev.langchain4j.data.message.TextContent;
import dev.langchain4j.data.message.ToolExecutionResultMessage;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.data.message.VideoContent;
import dev.langchain4j.data.video.Video;
import dev.langchain4j.exception.UnsupportedFeatureException;
import dev.langchain4j.internal.JsonSchemaElementUtils;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.StreamingResponseHandler;
import dev.langchain4j.model.chat.request.ChatRequest;
import dev.langchain4j.model.chat.request.ChatRequestParameters;
import dev.langchain4j.model.chat.request.ResponseFormatType;
import dev.langchain4j.model.chat.request.ToolChoice;
import dev.langchain4j.model.chat.request.json.JsonSchemaElement;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.chat.response.ChatResponseMetadata;
import dev.langchain4j.model.chat.response.StreamingChatResponseHandler;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.TokenUsage;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class QwenHelper {
    private static final Logger log = LoggerFactory.getLogger(QwenHelper.class);

    QwenHelper() {
    }

    static List<Message> toQwenMessages(List<ChatMessage> messages, Boolean enableSanitizeMessages) {
        List<ChatMessage> inputMessages = Boolean.FALSE.equals(enableSanitizeMessages) ? messages : QwenHelper.sanitizeMessages(messages);
        return inputMessages.stream().map(QwenHelper::toQwenMessage).collect(Collectors.toList());
    }

    static List<Message> toQwenMessages(Iterable<ChatMessage> messages) {
        LinkedList<Message> qwenMessages = new LinkedList<Message>();
        messages.forEach(message -> qwenMessages.add(QwenHelper.toQwenMessage(message)));
        return qwenMessages;
    }

    static Message toQwenMessage(ChatMessage message) {
        return Message.builder().role(QwenHelper.roleFrom(message)).content(QwenHelper.toSingleText(message)).name(QwenHelper.nameFrom(message)).toolCallId(QwenHelper.toolCallIdFrom(message)).toolCalls(QwenHelper.toolCallsFrom(message)).build();
    }

    static String toSingleText(ChatMessage message) {
        return switch (message.type()) {
            case ChatMessageType.USER -> ((UserMessage)message).contents().stream().filter(TextContent.class::isInstance).map(TextContent.class::cast).map(TextContent::text).collect(Collectors.joining("\n"));
            case ChatMessageType.AI -> ((AiMessage)message).text();
            case ChatMessageType.SYSTEM -> ((SystemMessage)message).text();
            case ChatMessageType.TOOL_EXECUTION_RESULT -> ((ToolExecutionResultMessage)message).text();
            default -> "";
        };
    }

    static String nameFrom(ChatMessage message) {
        return switch (message.type()) {
            case ChatMessageType.USER -> ((UserMessage)message).name();
            case ChatMessageType.TOOL_EXECUTION_RESULT -> ((ToolExecutionResultMessage)message).toolName();
            default -> null;
        };
    }

    static String toolCallIdFrom(ChatMessage message) {
        if (message.type() == ChatMessageType.TOOL_EXECUTION_RESULT) {
            return ((ToolExecutionResultMessage)message).id();
        }
        return null;
    }

    static List<ToolCallBase> toolCallsFrom(ChatMessage message) {
        if (message.type() == ChatMessageType.AI && ((AiMessage)message).hasToolExecutionRequests()) {
            return QwenHelper.toToolCalls(((AiMessage)message).toolExecutionRequests());
        }
        return null;
    }

    static List<MultiModalMessage> toQwenMultiModalMessages(List<ChatMessage> messages) {
        return messages.stream().map(QwenHelper::toQwenMultiModalMessage).collect(Collectors.toList());
    }

    static MultiModalMessage toQwenMultiModalMessage(ChatMessage message) {
        return MultiModalMessage.builder().role(QwenHelper.roleFrom(message)).content(QwenHelper.toMultiModalContents(message)).build();
    }

    static List<Map<String, Object>> toMultiModalContents(ChatMessage message) {
        return switch (message.type()) {
            case ChatMessageType.USER -> ((UserMessage)message).contents().stream().map(QwenHelper::toMultiModalContent).collect(Collectors.toList());
            case ChatMessageType.AI -> Collections.singletonList(Collections.singletonMap("text", ((AiMessage)message).text()));
            case ChatMessageType.SYSTEM -> Collections.singletonList(Collections.singletonMap("text", ((SystemMessage)message).text()));
            case ChatMessageType.TOOL_EXECUTION_RESULT -> Collections.singletonList(Collections.singletonMap("text", ((ToolExecutionResultMessage)message).text()));
            default -> Collections.emptyList();
        };
    }

    static Map<String, Object> toMultiModalContent(Content content) {
        switch (content.type()) {
            case IMAGE: {
                Image image = ((ImageContent)content).image();
                if (image.url() != null) {
                    String imageContent = image.url().toString();
                    return Collections.singletonMap("image", imageContent);
                }
                if (Utils.isNotNullOrBlank((String)image.base64Data())) {
                    return Collections.singletonMap("image", "data:%s;base64,%s".formatted(image.mimeType(), image.base64Data()));
                }
                return Collections.emptyMap();
            }
            case AUDIO: {
                Audio audio = ((AudioContent)content).audio();
                if (audio.url() != null) {
                    String audioContent = audio.url().toString();
                    return Collections.singletonMap("audio", audioContent);
                }
                if (Utils.isNotNullOrBlank((String)audio.base64Data())) {
                    return Collections.singletonMap("audio", "data:%s;base64,%s".formatted(audio.mimeType(), audio.base64Data()));
                }
                return Collections.emptyMap();
            }
            case VIDEO: {
                Video video = ((VideoContent)content).video();
                if (video.url() != null) {
                    String videoContent = video.url().toString();
                    return Collections.singletonMap("video", videoContent);
                }
                if (Utils.isNotNullOrBlank((String)video.base64Data())) {
                    return Collections.singletonMap("video", "data:%s;base64,%s".formatted(video.mimeType(), video.base64Data()));
                }
                return Collections.emptyMap();
            }
            case TEXT: {
                return Collections.singletonMap("text", ((TextContent)content).text());
            }
        }
        return Collections.emptyMap();
    }

    static String roleFrom(ChatMessage message) {
        if (message.type() == ChatMessageType.AI) {
            return Role.ASSISTANT.getValue();
        }
        if (message.type() == ChatMessageType.SYSTEM) {
            return Role.SYSTEM.getValue();
        }
        if (message.type() == ChatMessageType.TOOL_EXECUTION_RESULT) {
            return Role.TOOL.getValue();
        }
        return Role.USER.getValue();
    }

    static boolean hasAnswer(GenerationResult result) {
        return Optional.of(result).map(GenerationResult::getOutput).map(GenerationOutput::getChoices).filter(choices -> !choices.isEmpty()).map(choices -> (GenerationOutput.Choice)choices.get(0)).map(GenerationOutput.Choice::getMessage).map(Message::getContent).filter(Utils::isNotNullOrEmpty).isPresent();
    }

    static String answerFrom(GenerationResult result) {
        return Optional.of(result).map(GenerationResult::getOutput).map(GenerationOutput::getChoices).filter(choices -> !choices.isEmpty()).map(choices -> (GenerationOutput.Choice)choices.get(0)).map(GenerationOutput.Choice::getMessage).map(Message::getContent).orElseGet(() -> Optional.of(result).map(GenerationResult::getOutput).map(GenerationOutput::getText).orElse(""));
    }

    static boolean hasAnswer(MultiModalConversationResult result) {
        return Optional.of(result).map(MultiModalConversationResult::getOutput).map(MultiModalConversationOutput::getChoices).filter(choices -> !choices.isEmpty()).map(choices -> (MultiModalConversationOutput.Choice)choices.get(0)).map(MultiModalConversationOutput.Choice::getMessage).map(MultiModalMessage::getContent).filter(contents -> !contents.isEmpty()).isPresent();
    }

    static String answerFrom(MultiModalConversationResult result) {
        return Optional.of(result).map(MultiModalConversationResult::getOutput).map(MultiModalConversationOutput::getChoices).filter(choices -> !choices.isEmpty()).map(choices -> (MultiModalConversationOutput.Choice)choices.get(0)).map(MultiModalConversationOutput.Choice::getMessage).map(MultiModalMessage::getContent).filter(contents -> !contents.isEmpty()).map(contents -> (Map)contents.get(0)).map(content -> content.get("text")).map(String.class::cast).orElse("");
    }

    static TokenUsage tokenUsageFrom(GenerationResult result) {
        return Optional.of(result).map(GenerationResult::getUsage).map(usage -> new TokenUsage(usage.getInputTokens(), usage.getOutputTokens())).orElse(null);
    }

    static TokenUsage tokenUsageFrom(MultiModalConversationResult result) {
        return Optional.of(result).map(MultiModalConversationResult::getUsage).map(usage -> new TokenUsage(usage.getInputTokens(), usage.getOutputTokens())).orElse(null);
    }

    static FinishReason finishReasonFrom(GenerationResult result) {
        FinishReason finishReason;
        String finishReason2;
        GenerationOutput.Choice choice = (GenerationOutput.Choice)result.getOutput().getChoices().get(0);
        String string = finishReason2 = Utils.isNullOrEmpty((Collection)choice.getMessage().getToolCalls()) ? choice.getFinishReason() : "tool_calls";
        if (finishReason2 == null) {
            finishReason = null;
        } else {
            switch (finishReason2) {
                case "stop": {
                    finishReason = FinishReason.STOP;
                    break;
                }
                case "length": {
                    finishReason = FinishReason.LENGTH;
                    break;
                }
                case "tool_calls": {
                    finishReason = FinishReason.TOOL_EXECUTION;
                    break;
                }
                default: {
                    finishReason = null;
                }
            }
        }
        return finishReason;
    }

    static FinishReason finishReasonFrom(MultiModalConversationResult result) {
        String finishReason;
        return switch (finishReason = Optional.of(result).map(MultiModalConversationResult::getOutput).map(MultiModalConversationOutput::getChoices).filter(choices -> !choices.isEmpty()).map(choices -> (MultiModalConversationOutput.Choice)choices.get(0)).map(MultiModalConversationOutput.Choice::getFinishReason).orElse("")) {
            case "stop" -> FinishReason.STOP;
            case "length" -> FinishReason.LENGTH;
            default -> null;
        };
    }

    static String reasoningContentFrom(GenerationResult result) {
        return Optional.of(result).map(GenerationResult::getOutput).map(GenerationOutput::getChoices).filter(choices -> !choices.isEmpty()).map(choices -> (GenerationOutput.Choice)choices.get(0)).map(GenerationOutput.Choice::getMessage).map(Message::getReasoningContent).orElse(null);
    }

    static String reasoningContentFrom(MultiModalConversationResult result) {
        return Optional.of(result).map(MultiModalConversationResult::getOutput).map(MultiModalConversationOutput::getChoices).filter(choices -> !choices.isEmpty()).map(choices -> (MultiModalConversationOutput.Choice)choices.get(0)).map(MultiModalConversationOutput.Choice::getMessage).map(MultiModalMessage::getReasoningContent).orElse(null);
    }

    static boolean isMultimodalModelName(String modelName) {
        return modelName.contains("-vl-") || modelName.contains("-audio-");
    }

    static boolean isSupportingIncrementalOutputModelName(String modelName) {
        return !modelName.contains("-mt-");
    }

    static boolean isMultimodalModel(ChatRequest chatRequest) {
        ChatRequestParameters chatRequestParameters = chatRequest.parameters();
        if (!(chatRequestParameters instanceof QwenChatRequestParameters)) {
            throw new IllegalArgumentException("parameters should be an instance of QwenChatRequestParameters");
        }
        QwenChatRequestParameters qwenParameters = (QwenChatRequestParameters)chatRequestParameters;
        String modelName = qwenParameters.modelName();
        Boolean isMultimodalModel = qwenParameters.isMultimodalModel();
        isMultimodalModel = (Boolean)Utils.getOrDefault((Object)isMultimodalModel, (Object)QwenHelper.isMultimodalModelName(modelName));
        return Boolean.TRUE.equals(isMultimodalModel);
    }

    static boolean supportIncrementalOutput(ChatRequest chatRequest) {
        ChatRequestParameters chatRequestParameters = chatRequest.parameters();
        if (!(chatRequestParameters instanceof QwenChatRequestParameters)) {
            throw new IllegalArgumentException("parameters should be an instance of QwenChatRequestParameters");
        }
        QwenChatRequestParameters qwenParameters = (QwenChatRequestParameters)chatRequestParameters;
        String modelName = qwenParameters.modelName();
        Boolean supportIncrementalOutput = qwenParameters.supportIncrementalOutput();
        supportIncrementalOutput = (Boolean)Utils.getOrDefault((Object)supportIncrementalOutput, (Object)QwenHelper.isSupportingIncrementalOutputModelName(modelName));
        return Boolean.TRUE.equals(supportIncrementalOutput);
    }

    static List<ToolBase> toToolFunctions(Collection<ToolSpecification> toolSpecifications) {
        if (Utils.isNullOrEmpty(toolSpecifications)) {
            return Collections.emptyList();
        }
        return toolSpecifications.stream().map(QwenHelper::toToolFunction).collect(Collectors.toList());
    }

    static ToolBase toToolFunction(ToolSpecification toolSpecification) {
        FunctionDefinition functionDefinition = FunctionDefinition.builder().name(toolSpecification.name()).description((String)Utils.getOrDefault((Object)toolSpecification.description(), (Object)"")).parameters(QwenHelper.toParameters(toolSpecification)).build();
        return ToolFunction.builder().function(functionDefinition).build();
    }

    private static JsonObject toParameters(ToolSpecification toolSpecification) {
        if (toolSpecification.parameters() != null) {
            return JsonUtils.toJsonObject((Object)JsonSchemaElementUtils.toMap((JsonSchemaElement)toolSpecification.parameters()));
        }
        return JsonUtils.toJsonObject(Map.of());
    }

    static ChatResponse chatResponseFrom(String modelName, GenerationResult result) {
        return ChatResponse.builder().aiMessage(QwenHelper.aiMessageFrom(result)).metadata((ChatResponseMetadata)((QwenChatResponseMetadata.Builder)((QwenChatResponseMetadata.Builder)((QwenChatResponseMetadata.Builder)((QwenChatResponseMetadata.Builder)QwenChatResponseMetadata.builder().id(result.getRequestId())).modelName(modelName)).tokenUsage(QwenHelper.tokenUsageFrom(result))).finishReason(QwenHelper.finishReasonFrom(result))).searchInfo(QwenHelper.convertSearchInfo(result.getOutput().getSearchInfo())).reasoningContent(QwenHelper.reasoningContentFrom(result)).build()).build();
    }

    static AiMessage aiMessageFrom(GenerationResult result) {
        if (QwenHelper.isFunctionToolCalls(result)) {
            String text = QwenHelper.answerFrom(result);
            return Utils.isNullOrBlank((String)text) ? new AiMessage(QwenHelper.toolExecutionRequestsFrom(result)) : new AiMessage(text, QwenHelper.toolExecutionRequestsFrom(result));
        }
        return new AiMessage(QwenHelper.answerFrom(result));
    }

    private static List<ToolExecutionRequest> toolExecutionRequestsFrom(GenerationResult result) {
        return QwenHelper.toolCallsFrom(result).stream().filter(ToolCallFunction.class::isInstance).map(ToolCallFunction.class::cast).map(toolCall -> ToolExecutionRequest.builder().id((String)Utils.getOrDefault((Object)toolCall.getId(), () -> QwenHelper.toolCallIdFromMessage(result))).name(toolCall.getFunction().getName()).arguments(toolCall.getFunction().getArguments()).build()).collect(Collectors.toList());
    }

    static List<ToolCallBase> toolCallsFrom(GenerationResult result) {
        return Optional.of(result).map(GenerationResult::getOutput).map(GenerationOutput::getChoices).filter(choices -> !choices.isEmpty()).map(choices -> (GenerationOutput.Choice)choices.get(0)).map(GenerationOutput.Choice::getMessage).map(Message::getToolCalls).orElseThrow(IllegalStateException::new);
    }

    static String toolCallIdFromMessage(GenerationResult result) {
        return Optional.of(result).map(GenerationResult::getOutput).map(GenerationOutput::getChoices).filter(choices -> !choices.isEmpty()).map(choices -> (GenerationOutput.Choice)choices.get(0)).map(GenerationOutput.Choice::getMessage).map(Message::getToolCallId).orElse(null);
    }

    static boolean isFunctionToolCalls(GenerationResult result) {
        Optional<List> toolCallBases = Optional.of(result).map(GenerationResult::getOutput).map(GenerationOutput::getChoices).filter(choices -> !choices.isEmpty()).map(choices -> (GenerationOutput.Choice)choices.get(0)).map(GenerationOutput.Choice::getMessage).map(Message::getToolCalls);
        return toolCallBases.isPresent() && !Utils.isNullOrEmpty((Collection)toolCallBases.get());
    }

    static ChatResponse chatResponseFrom(String modelName, MultiModalConversationResult result) {
        return ChatResponse.builder().aiMessage(QwenHelper.aiMessageFrom(result)).metadata((ChatResponseMetadata)((QwenChatResponseMetadata.Builder)((QwenChatResponseMetadata.Builder)((QwenChatResponseMetadata.Builder)((QwenChatResponseMetadata.Builder)QwenChatResponseMetadata.builder().id(result.getRequestId())).modelName(modelName)).tokenUsage(QwenHelper.tokenUsageFrom(result))).finishReason(QwenHelper.finishReasonFrom(result))).reasoningContent(QwenHelper.reasoningContentFrom(result)).build()).build();
    }

    static AiMessage aiMessageFrom(MultiModalConversationResult result) {
        return new AiMessage(QwenHelper.answerFrom(result));
    }

    private static List<ToolCallBase> toToolCalls(Collection<ToolExecutionRequest> toolExecutionRequests) {
        return toolExecutionRequests.stream().map(QwenHelper::toToolCall).collect(Collectors.toList());
    }

    private static ToolCallBase toToolCall(ToolExecutionRequest toolExecutionRequest) {
        ToolCallFunction toolCallFunction = new ToolCallFunction();
        toolCallFunction.setId(toolExecutionRequest.id());
        ToolCallFunction.CallFunction callFunction = new ToolCallFunction.CallFunction(toolCallFunction);
        callFunction.setName(toolExecutionRequest.name());
        callFunction.setArguments(toolExecutionRequest.arguments());
        toolCallFunction.setFunction(callFunction);
        return toolCallFunction;
    }

    static List<ChatMessage> sanitizeMessages(List<ChatMessage> messages) {
        LinkedList<ChatMessage> sanitizedMessages = messages.stream().reduce(new LinkedList(), QwenHelper.messageAccumulator(), QwenHelper.messageCombiner());
        while (!sanitizedMessages.isEmpty() && !QwenHelper.isInputMessageType(sanitizedMessages.getLast())) {
            ChatMessage removedMessage = sanitizedMessages.removeLast();
            log.warn("The last message should be a user/tool_execution_result message, but found: {}", (Object)removedMessage);
        }
        return sanitizedMessages;
    }

    private static BiFunction<LinkedList<ChatMessage>, ChatMessage, LinkedList<ChatMessage>> messageAccumulator() {
        return (acc, message) -> {
            ChatMessageType type = message.type();
            if (acc.isEmpty()) {
                if (type == ChatMessageType.SYSTEM || type == ChatMessageType.USER) {
                    acc.add(message);
                } else {
                    log.warn("The first message should be a system message or a user message, but found: {}", message);
                }
                return acc;
            }
            if (type == ChatMessageType.SYSTEM) {
                if (((ChatMessage)acc.getFirst()).type() == ChatMessageType.SYSTEM) {
                    log.warn("Drop existed system message: {}", acc);
                    acc.removeFirst();
                }
                acc.addFirst(message);
                return acc;
            }
            ChatMessageType lastType = ((ChatMessage)acc.getLast()).type();
            if (lastType == ChatMessageType.SYSTEM && type != ChatMessageType.USER) {
                log.warn("The first non-system message must be a user message, but found: {}", message);
                return acc;
            }
            if (type == ChatMessageType.USER) {
                while (!acc.isEmpty() && ((ChatMessage)acc.getLast()).type() != ChatMessageType.SYSTEM && !QwenHelper.isNormalAiType((ChatMessage)acc.getLast())) {
                    ChatMessage removedMessage = (ChatMessage)acc.removeLast();
                    log.warn("Tool execution result should follow a tool execution request message. Drop duplicated message: {}", (Object)removedMessage);
                }
            } else if (type == ChatMessageType.TOOL_EXECUTION_RESULT) {
                while (!QwenHelper.isToolExecutionRequestsAiType((ChatMessage)acc.getLast())) {
                    ChatMessage removedMessage = (ChatMessage)acc.removeLast();
                    log.warn("Tool execution result should follow a tool execution request message. Drop duplicated message: {}", (Object)removedMessage);
                    if (!acc.isEmpty()) continue;
                    log.error("The first message should be a system/user message");
                    throw new IllegalArgumentException("The first message should be a system/user message");
                }
            } else if (type == ChatMessageType.AI) {
                while (!QwenHelper.isInputMessageType((ChatMessage)acc.getLast())) {
                    ChatMessage removedMessage = (ChatMessage)acc.removeLast();
                    log.warn("AI message should follow a user/tool_execution_result message. Drop duplicated message: {}", (Object)removedMessage);
                    if (!acc.isEmpty()) continue;
                    log.error("The first message should be a system/user message");
                    throw new IllegalArgumentException("The first message should be a system/user message");
                }
            }
            acc.add(message);
            return acc;
        };
    }

    private static BinaryOperator<LinkedList<ChatMessage>> messageCombiner() {
        return (acc1, acc2) -> {
            throw new UnsupportedOperationException("Parallel stream not supported");
        };
    }

    private static boolean isInputMessageType(ChatMessage message) {
        ChatMessageType type = message.type();
        return type == ChatMessageType.USER || type == ChatMessageType.TOOL_EXECUTION_RESULT;
    }

    private static boolean isNormalAiType(ChatMessage message) {
        return message.type() == ChatMessageType.AI && !((AiMessage)message).hasToolExecutionRequests();
    }

    private static boolean isToolExecutionRequestsAiType(ChatMessage message) {
        return message.type() == ChatMessageType.AI && ((AiMessage)message).hasToolExecutionRequests();
    }

    public static Response<AiMessage> convertResponse(ChatResponse chatResponse) {
        return Response.from((Object)chatResponse.aiMessage(), (TokenUsage)chatResponse.metadata().tokenUsage(), (FinishReason)chatResponse.metadata().finishReason(), ((QwenChatResponseMetadata)chatResponse.metadata()).toMap());
    }

    static StreamingChatResponseHandler convertHandler(final StreamingResponseHandler<AiMessage> handler) {
        return new StreamingChatResponseHandler(){

            public void onPartialResponse(String partialResponse) {
                handler.onNext(partialResponse);
            }

            public void onCompleteResponse(ChatResponse completeResponse) {
                handler.onComplete(QwenHelper.convertResponse(completeResponse));
            }

            public void onError(Throwable error) {
                handler.onError(error);
            }
        };
    }

    static QwenChatResponseMetadata.SearchInfo convertSearchInfo(SearchInfo searchInfo) {
        List<QwenChatResponseMetadata.SearchResult> searchResults = Objects.isNull(searchInfo) || Utils.isNullOrEmpty((Collection)searchInfo.getSearchResults()) ? Collections.emptyList() : searchInfo.getSearchResults().stream().map(QwenHelper::convertSearchResult).collect(Collectors.toList());
        return QwenChatResponseMetadata.SearchInfo.builder().searchResults(searchResults).build();
    }

    static QwenChatResponseMetadata.SearchResult convertSearchResult(SearchInfo.SearchResult searchResult) {
        return QwenChatResponseMetadata.SearchResult.builder().siteName(searchResult.getSiteName()).icon(searchResult.getIcon()).index(searchResult.getIndex()).title(searchResult.getTitle()).url(searchResult.getUrl()).build();
    }

    static void validateGenerationParameters(QwenChatRequestParameters parameters) {
        if (parameters.vlHighResolutionImages() != null) {
            throw new UnsupportedFeatureException("'vlHighResolutionImages' parameter is not supported by " + parameters.modelName());
        }
        if (parameters.responseFormat() != null && parameters.responseFormat().jsonSchema() != null) {
            throw new UnsupportedFeatureException("JSON response format is not supported by " + parameters.modelName());
        }
    }

    static void validateMultimodalConversationParameters(QwenChatRequestParameters parameters) {
        if (parameters.searchOptions() != null) {
            throw new UnsupportedFeatureException("'searchOptions' parameter is not supported by " + parameters.modelName());
        }
        if (parameters.frequencyPenalty() != null) {
            throw new UnsupportedFeatureException("'frequencyPenalty' parameter is not supported by " + parameters.modelName());
        }
        if (parameters.toolChoice() != null) {
            throw new UnsupportedFeatureException("'toolChoice' parameter is not supported by " + parameters.modelName());
        }
        if (!Utils.isNullOrEmpty((Collection)parameters.toolSpecifications())) {
            throw new UnsupportedFeatureException("'toolSpecifications' parameter is not supported by " + parameters.modelName());
        }
        if (parameters.translationOptions() != null) {
            throw new UnsupportedFeatureException("'translationOptions' parameter is not supported by " + parameters.modelName());
        }
        if (parameters.responseFormat() != null) {
            throw new UnsupportedFeatureException("'responseFormat' parameter is not supported by " + parameters.modelName());
        }
    }

    static GenerationParam toGenerationParam(String apiKey, ChatRequest chatRequest, Consumer<GenerationParam.GenerationParamBuilder<?, ?>> generationParamCustomizer, boolean incrementalOutput) {
        QwenChatRequestParameters parameters = (QwenChatRequestParameters)chatRequest.parameters();
        QwenHelper.validateGenerationParameters(parameters);
        GenerationParam.GenerationParamBuilder builder = ((GenerationParam.GenerationParamBuilder)((GenerationParam.GenerationParamBuilder)GenerationParam.builder().apiKey(apiKey)).model(parameters.modelName())).topP(parameters.topP()).topK(parameters.topK()).enableSearch((Boolean)Utils.getOrDefault((Object)parameters.enableSearch(), (Object)false)).searchOptions(QwenHelper.toQwenSearchOptions(parameters.searchOptions())).seed(parameters.seed()).repetitionPenalty(QwenHelper.frequencyPenaltyToRepetitionPenalty(parameters.frequencyPenalty())).maxTokens(parameters.maxOutputTokens()).messages(QwenHelper.toQwenMessages(chatRequest.messages(), parameters.enableSanitizeMessages())).responseFormat(QwenHelper.toQwenResponseFormat(parameters.responseFormat())).resultFormat(ConversationParam.ResultFormat.MESSAGE).incrementalOutput(Boolean.valueOf(incrementalOutput)).enableThinking(parameters.enableThinking()).thinkingBudget(parameters.thinkingBudget());
        if (parameters.temperature() != null) {
            builder.temperature(Float.valueOf(parameters.temperature().floatValue()));
        }
        if (parameters.stopSequences() != null) {
            builder.stopStrings((Collection)parameters.stopSequences());
        }
        if (!Utils.isNullOrEmpty((Collection)parameters.toolSpecifications())) {
            builder.tools(QwenHelper.toToolFunctions(parameters.toolSpecifications()));
            if (parameters.toolChoice() != null && parameters.toolChoice() == ToolChoice.REQUIRED) {
                builder.toolChoice((Object)QwenHelper.toToolFunction((ToolSpecification)parameters.toolSpecifications().get(0)));
            }
        }
        if (parameters.translationOptions() != null) {
            builder.parameter("translation_options", QwenHelper.toQwenTranslationOptions(parameters.translationOptions()));
        }
        if (parameters.custom() != null) {
            builder.parameter("custom", parameters.custom());
        }
        if (generationParamCustomizer != null) {
            generationParamCustomizer.accept(builder);
        }
        return builder.build();
    }

    static MultiModalConversationParam toMultiModalConversationParam(String apiKey, ChatRequest chatRequest, Consumer<MultiModalConversationParam.MultiModalConversationParamBuilder<?, ?>> multimodalConversationParamCustomizer, boolean incrementalOutput) {
        QwenChatRequestParameters parameters = (QwenChatRequestParameters)chatRequest.parameters();
        QwenHelper.validateMultimodalConversationParameters(parameters);
        MultiModalConversationParam.MultiModalConversationParamBuilder builder = ((MultiModalConversationParam.MultiModalConversationParamBuilder)((MultiModalConversationParam.MultiModalConversationParamBuilder)MultiModalConversationParam.builder().apiKey(apiKey)).model(parameters.modelName())).topP(parameters.topP()).topK(parameters.topK()).enableSearch((Boolean)Utils.getOrDefault((Object)parameters.enableSearch(), (Object)false)).seed(parameters.seed()).maxTokens(parameters.maxOutputTokens()).messages(QwenHelper.toQwenMultiModalMessages(chatRequest.messages())).incrementalOutput(Boolean.valueOf(incrementalOutput));
        if (parameters.temperature() != null) {
            builder.temperature(Float.valueOf(parameters.temperature().floatValue()));
        }
        if (!Utils.isNullOrEmpty((Collection)parameters.stopSequences())) {
            builder.parameter("stop", (Object)parameters.stopSequences());
        }
        if (parameters.vlHighResolutionImages() != null) {
            builder.parameter("vl_high_resolution_images", (Object)parameters.vlHighResolutionImages());
        }
        if (parameters.custom() != null) {
            builder.parameter("custom", parameters.custom());
        }
        if (multimodalConversationParamCustomizer != null) {
            multimodalConversationParamCustomizer.accept(builder);
        }
        return builder.build();
    }

    static ResponseFormat toQwenResponseFormat(dev.langchain4j.model.chat.request.ResponseFormat responseFormat) {
        if (responseFormat == null) {
            return null;
        }
        return switch (responseFormat.type()) {
            default -> throw new IncompatibleClassChangeError();
            case ResponseFormatType.JSON -> ResponseFormat.from((Object)"json_object");
            case ResponseFormatType.TEXT -> ResponseFormat.from((Object)"text");
        };
    }

    static SearchOptions toQwenSearchOptions(QwenChatRequestParameters.SearchOptions searchOptions) {
        if (searchOptions == null) {
            return null;
        }
        return SearchOptions.builder().citationFormat(searchOptions.citationFormat()).enableCitation(searchOptions.enableCitation()).enableSource(searchOptions.enableSource()).forcedSearch(searchOptions.forcedSearch()).searchStrategy(searchOptions.searchStrategy()).build();
    }

    static Map<String, Object> toQwenTranslationOptions(QwenChatRequestParameters.TranslationOptions translationOptions) {
        if (translationOptions == null) {
            return null;
        }
        HashMap<String, Object> translationOptionsMap = new HashMap<String, Object>(5);
        translationOptionsMap.put("source_lang", translationOptions.sourceLang());
        translationOptionsMap.put("target_lang", translationOptions.targetLang());
        translationOptionsMap.put("terms", QwenHelper.toTermList(translationOptions.terms()));
        translationOptionsMap.put("tm_list", QwenHelper.toTermList(translationOptions.tmList()));
        translationOptionsMap.put("domains", translationOptions.domains());
        return translationOptionsMap;
    }

    static List<Map<String, String>> toTermList(List<QwenChatRequestParameters.TranslationOptionTerm> list) {
        if (list == null) {
            return null;
        }
        return list.stream().map(term -> Map.of("source", term.source(), "target", term.target())).collect(Collectors.toList());
    }

    static Float frequencyPenaltyToRepetitionPenalty(Double frequencyPenalty) {
        if (frequencyPenalty == null) {
            return null;
        }
        if (frequencyPenalty >= 2.0) {
            return Float.valueOf(Float.POSITIVE_INFINITY);
        }
        if (frequencyPenalty < -2.0) {
            throw new IllegalArgumentException("Value of frequencyPenalty must be within [-2.0, 2.0]");
        }
        double x = (frequencyPenalty + 6.0) / 8.0;
        double denominator = QwenHelper.logit(0.75);
        return Float.valueOf((float)(QwenHelper.logit(x) / denominator));
    }

    static Double repetitionPenaltyToFrequencyPenalty(Float repetitionPenalty) {
        if (repetitionPenalty == null) {
            return null;
        }
        if (repetitionPenalty.floatValue() <= 0.0f) {
            throw new IllegalArgumentException("Value of repetitionPenalty must be positive number");
        }
        double factor = QwenHelper.logit(0.75);
        double y = QwenHelper.sigmoid(repetitionPenalty.doubleValue() * factor);
        return y * 8.0 - 6.0;
    }

    private static double logit(double x) {
        return Math.log(x / (1.0 - x));
    }

    private static double sigmoid(double x) {
        return 1.0 / (1.0 + Math.exp(-x));
    }
}

