/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.bedrock;

import dev.langchain4j.internal.InternalStreamingChatResponseHandlerUtils;
import dev.langchain4j.internal.ToolCallBuilder;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.ModelProvider;
import dev.langchain4j.model.bedrock.AbstractBedrockChatModel;
import dev.langchain4j.model.bedrock.AwsLoggingInterceptor;
import dev.langchain4j.model.bedrock.BedrockCachePointPlacement;
import dev.langchain4j.model.bedrock.BedrockChatRequestParameters;
import dev.langchain4j.model.bedrock.BedrockExceptionMapper;
import dev.langchain4j.model.bedrock.BedrockStreamingHandle;
import dev.langchain4j.model.bedrock.ConverseResponseFromStreamBuilder;
import dev.langchain4j.model.chat.StreamingChatModel;
import dev.langchain4j.model.chat.listener.ChatModelListener;
import dev.langchain4j.model.chat.request.ChatRequest;
import dev.langchain4j.model.chat.request.ChatRequestParameters;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.chat.response.ChatResponseMetadata;
import dev.langchain4j.model.chat.response.CompleteToolCall;
import dev.langchain4j.model.chat.response.StreamingChatResponseHandler;
import dev.langchain4j.model.chat.response.StreamingHandle;
import dev.langchain4j.model.output.TokenUsage;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.services.bedrockruntime.BedrockRuntimeAsyncClient;
import software.amazon.awssdk.services.bedrockruntime.BedrockRuntimeAsyncClientBuilder;
import software.amazon.awssdk.services.bedrockruntime.model.ContentBlockDelta;
import software.amazon.awssdk.services.bedrockruntime.model.ContentBlockDeltaEvent;
import software.amazon.awssdk.services.bedrockruntime.model.ContentBlockStart;
import software.amazon.awssdk.services.bedrockruntime.model.ContentBlockStartEvent;
import software.amazon.awssdk.services.bedrockruntime.model.ContentBlockStopEvent;
import software.amazon.awssdk.services.bedrockruntime.model.ConverseResponse;
import software.amazon.awssdk.services.bedrockruntime.model.ConverseStreamMetadataEvent;
import software.amazon.awssdk.services.bedrockruntime.model.ConverseStreamOutput;
import software.amazon.awssdk.services.bedrockruntime.model.ConverseStreamRequest;
import software.amazon.awssdk.services.bedrockruntime.model.ConverseStreamResponseHandler;
import software.amazon.awssdk.services.bedrockruntime.model.MessageStartEvent;
import software.amazon.awssdk.services.bedrockruntime.model.MessageStopEvent;
import software.amazon.awssdk.services.bedrockruntime.model.ReasoningContentBlockDelta;

public class BedrockStreamingChatModel
extends AbstractBedrockChatModel
implements StreamingChatModel {
    private static final Logger log = LoggerFactory.getLogger(BedrockStreamingChatModel.class);
    private final BedrockRuntimeAsyncClient client;
    private final boolean logResponses;

    public BedrockStreamingChatModel(String modelId) {
        this((Builder)BedrockStreamingChatModel.builder().modelId(modelId));
    }

    public BedrockStreamingChatModel(Builder builder) {
        super(builder);
        this.client = Objects.isNull(builder.client) ? this.createClient((Boolean)Utils.getOrDefault((Object)builder.logRequests, (Object)false), (Boolean)Utils.getOrDefault((Object)builder.logResponses, (Object)false), builder.logger) : builder.client;
        this.logResponses = (Boolean)Utils.getOrDefault((Object)builder.logResponses, (Object)false);
    }

    public void doChat(ChatRequest chatRequest, final StreamingChatResponseHandler handler) {
        BedrockStreamingChatModel.validate(chatRequest.parameters());
        final ConverseStreamRequest converseStreamRequest = this.buildConverseStreamRequest(chatRequest);
        final ConverseResponseFromStreamBuilder responseBuilder = new ConverseResponseFromStreamBuilder(this.returnThinking);
        final ToolCallBuilder toolCallBuilder = new ToolCallBuilder(-1);
        final AtomicReference currentContentType = new AtomicReference();
        final AtomicReference streamingHandle = new AtomicReference();
        ConverseStreamResponseHandler converseStreamResponseHandler = ((ConverseStreamResponseHandler.Builder)ConverseStreamResponseHandler.builder().onEventStream(publisher -> publisher.subscribe((Subscriber)new Subscriber<ConverseStreamOutput>(){
            volatile Subscription subscription;
            final /* synthetic */ BedrockStreamingChatModel this$0;
            {
                this.this$0 = this$0;
            }

            public void onSubscribe(Subscription subscription) {
                this.subscription = subscription;
                streamingHandle.set(new BedrockStreamingHandle(subscription));
                subscription.request(1L);
            }

            public void onNext(ConverseStreamOutput output) {
                if (output instanceof MessageStartEvent) {
                    MessageStartEvent event = (MessageStartEvent)output;
                    if (this.this$0.logResponses) {
                        log.debug("onMessageStart: {}", (Object)event);
                    }
                    responseBuilder.append(event);
                } else if (output instanceof ContentBlockStartEvent) {
                    ContentBlockStartEvent event = (ContentBlockStartEvent)output;
                    if (this.this$0.logResponses) {
                        log.debug("onContentBlockStart: {}", (Object)event);
                    }
                    if (event.start().type() == ContentBlockStart.Type.TOOL_USE) {
                        toolCallBuilder.updateIndex(Integer.valueOf(toolCallBuilder.index() + 1));
                        toolCallBuilder.updateId(event.start().toolUse().toolUseId());
                        toolCallBuilder.updateName(event.start().toolUse().name());
                    }
                    responseBuilder.append(event);
                } else if (output instanceof ContentBlockDeltaEvent) {
                    String input;
                    ContentBlockDeltaEvent event = (ContentBlockDeltaEvent)output;
                    if (this.this$0.logResponses) {
                        log.debug("onContentBlockDelta: {}", (Object)event);
                    }
                    ContentBlockDelta delta = event.delta();
                    currentContentType.set(delta.type());
                    if (currentContentType.get() == ContentBlockDelta.Type.TEXT) {
                        InternalStreamingChatResponseHandlerUtils.onPartialResponse((StreamingChatResponseHandler)handler, (String)delta.text(), (StreamingHandle)((StreamingHandle)streamingHandle.get()));
                    } else if (currentContentType.get() == ContentBlockDelta.Type.REASONING_CONTENT) {
                        ReasoningContentBlockDelta reasoningContent = delta.reasoningContent();
                        String thinking = reasoningContent.text();
                        if (Utils.isNotNullOrEmpty((String)thinking)) {
                            InternalStreamingChatResponseHandlerUtils.onPartialThinking((StreamingChatResponseHandler)handler, (String)thinking, (StreamingHandle)((StreamingHandle)streamingHandle.get()));
                        }
                    } else if (currentContentType.get() == ContentBlockDelta.Type.TOOL_USE && Utils.isNotNullOrEmpty((String)(input = delta.toolUse().input()))) {
                        toolCallBuilder.appendArguments(input);
                    }
                    responseBuilder.append(delta);
                } else if (output instanceof ContentBlockStopEvent) {
                    ContentBlockStopEvent event = (ContentBlockStopEvent)output;
                    if (this.this$0.logResponses) {
                        log.debug("onContentBlockStop: {}", (Object)event);
                    }
                    if (currentContentType.get() == ContentBlockDelta.Type.TOOL_USE) {
                        InternalStreamingChatResponseHandlerUtils.onCompleteToolCall((StreamingChatResponseHandler)handler, (CompleteToolCall)toolCallBuilder.buildAndReset());
                    }
                    responseBuilder.append(event);
                } else if (output instanceof MessageStopEvent) {
                    MessageStopEvent event = (MessageStopEvent)output;
                    if (this.this$0.logResponses) {
                        log.debug("onMessageStop: {}", (Object)event);
                    }
                    responseBuilder.append(event);
                } else if (output instanceof ConverseStreamMetadataEvent) {
                    ConverseStreamMetadataEvent event = (ConverseStreamMetadataEvent)output;
                    if (this.this$0.logResponses) {
                        log.debug("onMetadata: {}", (Object)event);
                    }
                    responseBuilder.append(event);
                    ChatResponse response = this.this$0.responseFrom(responseBuilder.build(), converseStreamRequest.modelId());
                    InternalStreamingChatResponseHandlerUtils.onCompleteResponse((StreamingChatResponseHandler)handler, (ChatResponse)response);
                }
                this.subscription.request(1L);
            }

            public void onError(Throwable error) {
                RuntimeException mappedError = BedrockExceptionMapper.INSTANCE.mapException(error);
                InternalStreamingChatResponseHandlerUtils.withLoggingExceptions(() -> handler.onError((Throwable)mappedError));
            }

            public void onComplete() {
            }
        }))).build();
        this.client.converseStream(converseStreamRequest, converseStreamResponseHandler).exceptionally(ex -> {
            RuntimeException mappedError = BedrockExceptionMapper.INSTANCE.mapException((Throwable)ex);
            InternalStreamingChatResponseHandlerUtils.withLoggingExceptions(() -> handler.onError((Throwable)mappedError));
            return null;
        });
    }

    public BedrockChatRequestParameters defaultRequestParameters() {
        return this.defaultRequestParameters;
    }

    private ConverseStreamRequest buildConverseStreamRequest(ChatRequest chatRequest) {
        BedrockCachePointPlacement cachePointPlacement = null;
        ChatRequestParameters chatRequestParameters = chatRequest.parameters();
        if (chatRequestParameters instanceof BedrockChatRequestParameters) {
            BedrockChatRequestParameters bedrockParams = (BedrockChatRequestParameters)chatRequestParameters;
            cachePointPlacement = bedrockParams.cachePointPlacement();
        } else if (this.defaultRequestParameters != null) {
            cachePointPlacement = this.defaultRequestParameters.cachePointPlacement();
        }
        return (ConverseStreamRequest)ConverseStreamRequest.builder().modelId(chatRequest.modelName()).inferenceConfig(this.inferenceConfigFrom(chatRequest.parameters())).system(this.extractSystemMessages(chatRequest.messages(), cachePointPlacement)).messages(this.extractRegularMessages(chatRequest.messages(), cachePointPlacement)).toolConfig(this.extractToolConfigurationFrom(chatRequest, cachePointPlacement)).additionalModelRequestFields(this.additionalRequestModelFieldsFrom(chatRequest.parameters())).build();
    }

    private ChatResponse responseFrom(ConverseResponse converseResponse, String modelId) {
        return ChatResponse.builder().aiMessage(this.aiMessageFrom(converseResponse)).metadata(ChatResponseMetadata.builder().id(UUID.randomUUID().toString()).finishReason(this.finishReasonFrom(converseResponse.stopReason())).tokenUsage((TokenUsage)this.tokenUsageFrom(converseResponse.usage())).modelName(modelId).build()).build();
    }

    public List<ChatModelListener> listeners() {
        return this.listeners;
    }

    public ModelProvider provider() {
        return ModelProvider.AMAZON_BEDROCK;
    }

    public static Builder builder() {
        return new Builder();
    }

    private BedrockRuntimeAsyncClient createClient(boolean logRequests, boolean logResponses, Logger logger) {
        return (BedrockRuntimeAsyncClient)((BedrockRuntimeAsyncClientBuilder)((BedrockRuntimeAsyncClientBuilder)((BedrockRuntimeAsyncClientBuilder)BedrockRuntimeAsyncClient.builder().region(this.region)).credentialsProvider((AwsCredentialsProvider)DefaultCredentialsProvider.create())).overrideConfiguration(config -> {
            config.apiCallTimeout(this.timeout);
            if (logRequests || logResponses) {
                config.addExecutionInterceptor((ExecutionInterceptor)new AwsLoggingInterceptor(logRequests, logResponses, logger));
            }
        })).build();
    }

    public static class Builder
    extends AbstractBedrockChatModel.AbstractBuilder<Builder> {
        private BedrockRuntimeAsyncClient client;

        public Builder client(BedrockRuntimeAsyncClient client) {
            this.client = client;
            return this;
        }

        public BedrockStreamingChatModel build() {
            return new BedrockStreamingChatModel(this);
        }
    }
}

