/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.bedrock;

import dev.langchain4j.Internal;
import dev.langchain4j.model.bedrock.AwsDocumentConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import software.amazon.awssdk.services.bedrockruntime.model.ContentBlock;
import software.amazon.awssdk.services.bedrockruntime.model.ContentBlockDelta;
import software.amazon.awssdk.services.bedrockruntime.model.ContentBlockDeltaEvent;
import software.amazon.awssdk.services.bedrockruntime.model.ContentBlockStart;
import software.amazon.awssdk.services.bedrockruntime.model.ContentBlockStartEvent;
import software.amazon.awssdk.services.bedrockruntime.model.ContentBlockStopEvent;
import software.amazon.awssdk.services.bedrockruntime.model.ConverseResponse;
import software.amazon.awssdk.services.bedrockruntime.model.ConverseStreamMetadataEvent;
import software.amazon.awssdk.services.bedrockruntime.model.Message;
import software.amazon.awssdk.services.bedrockruntime.model.MessageStartEvent;
import software.amazon.awssdk.services.bedrockruntime.model.MessageStopEvent;
import software.amazon.awssdk.services.bedrockruntime.model.ToolUseBlock;

@Internal
class ConverseResponseFromStreamBuilder {
    private final ConverseResponse.Builder converseResponseBuilder = ConverseResponse.builder();
    private Message.Builder messageBuilder = Message.builder();
    private final StringBuilder stringBuilder = new StringBuilder();
    private ToolUseBlock.Builder toolUseBlockBuilder = null;
    private StringBuilder toolUseInputBuilder = new StringBuilder();
    private final List<ToolUseBlock> toolUseBlocks = new ArrayList<ToolUseBlock>();

    ConverseResponseFromStreamBuilder() {
    }

    public static ConverseResponseFromStreamBuilder builder() {
        return new ConverseResponseFromStreamBuilder();
    }

    public ConverseResponseFromStreamBuilder append(ContentBlockStartEvent contentBlockStartEvent) {
        if (contentBlockStartEvent.start().type().equals((Object)ContentBlockStart.Type.TOOL_USE)) {
            this.toolUseBlockBuilder = ToolUseBlock.builder().toolUseId(contentBlockStartEvent.start().toolUse().toolUseId()).name(contentBlockStartEvent.start().toolUse().name());
        }
        return this;
    }

    public ConverseResponseFromStreamBuilder append(ContentBlockDeltaEvent contentBlockDeltaEvent) {
        if (contentBlockDeltaEvent.delta().type().equals((Object)ContentBlockDelta.Type.TEXT)) {
            this.stringBuilder.append(contentBlockDeltaEvent.delta().text());
        } else if (contentBlockDeltaEvent.delta().type().equals((Object)ContentBlockDelta.Type.TOOL_USE)) {
            this.toolUseInputBuilder.append(contentBlockDeltaEvent.delta().toolUse().input());
        }
        return this;
    }

    public ConverseResponseFromStreamBuilder append(ContentBlockStopEvent contentBlockStopEvent) {
        if (Objects.nonNull(this.toolUseBlockBuilder)) {
            if (!this.toolUseInputBuilder.isEmpty()) {
                this.toolUseBlockBuilder.input(AwsDocumentConverter.documentFromJson(this.toolUseInputBuilder.toString()));
            }
            this.toolUseBlocks.add((ToolUseBlock)this.toolUseBlockBuilder.build());
            this.toolUseInputBuilder = new StringBuilder();
            this.toolUseBlockBuilder = null;
        }
        return this;
    }

    public ConverseResponseFromStreamBuilder append(ConverseStreamMetadataEvent metadataEvent) {
        this.converseResponseBuilder.usage(metadataEvent.usage());
        this.converseResponseBuilder.metrics(builder -> builder.latencyMs(metadataEvent.metrics().latencyMs()).build());
        return this;
    }

    public ConverseResponseFromStreamBuilder append(MessageStartEvent messageStartEvent) {
        this.messageBuilder = Message.builder();
        this.messageBuilder.role(messageStartEvent.role());
        return this;
    }

    public ConverseResponseFromStreamBuilder append(MessageStopEvent messageStopEvent) {
        this.converseResponseBuilder.stopReason(messageStopEvent.stopReason());
        this.converseResponseBuilder.additionalModelResponseFields(messageStopEvent.additionalModelResponseFields());
        if (Objects.nonNull(this.messageBuilder)) {
            ArrayList<ContentBlock> contents = new ArrayList<ContentBlock>();
            contents.add((ContentBlock)ContentBlock.builder().text(this.stringBuilder.toString()).build());
            contents.addAll(this.toolUseBlocks.stream().map(ContentBlock::fromToolUse).toList());
            this.converseResponseBuilder.output(builder -> builder.message((Message)this.messageBuilder.content((Collection)contents).build()).build());
            this.messageBuilder = null;
        }
        return this;
    }

    public ConverseResponse build() {
        return (ConverseResponse)this.converseResponseBuilder.build();
    }
}

