/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.bedrock;

import dev.langchain4j.model.bedrock.internal.BedrockChatModelResponse;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.TokenUsage;
import java.util.List;

public class BedrockTitanChatModelResponse
implements BedrockChatModelResponse {
    private int inputTextTokenCount;
    private List<Result> results;

    @Override
    public String getOutputText() {
        if (this.results.isEmpty()) {
            throw new IllegalStateException("No results returned");
        }
        return this.results.get(0).outputText;
    }

    @Override
    public FinishReason getFinishReason() {
        if (this.results.isEmpty()) {
            throw new IllegalStateException("No results returned");
        }
        Result result = this.results.get(0);
        switch (result.completionReason) {
            case "FINISH": {
                return FinishReason.STOP;
            }
        }
        return FinishReason.LENGTH;
    }

    @Override
    public TokenUsage getTokenUsage() {
        if (this.results.isEmpty()) {
            throw new IllegalStateException("No results returned");
        }
        Result result = this.results.get(0);
        return new TokenUsage(Integer.valueOf(this.inputTextTokenCount), Integer.valueOf(result.tokenCount));
    }

    public int getInputTextTokenCount() {
        return this.inputTextTokenCount;
    }

    public List<Result> getResults() {
        return this.results;
    }

    public void setInputTextTokenCount(int inputTextTokenCount) {
        this.inputTextTokenCount = inputTextTokenCount;
    }

    public void setResults(List<Result> results) {
        this.results = results;
    }

    public static class Result {
        private int tokenCount;
        private String outputText;
        private String completionReason;

        public int getTokenCount() {
            return this.tokenCount;
        }

        public String getOutputText() {
            return this.outputText;
        }

        public String getCompletionReason() {
            return this.completionReason;
        }

        public void setTokenCount(int tokenCount) {
            this.tokenCount = tokenCount;
        }

        public void setOutputText(String outputText) {
            this.outputText = outputText;
        }

        public void setCompletionReason(String completionReason) {
            this.completionReason = completionReason;
        }
    }
}

