/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.agentic.observability;

import dev.langchain4j.agentic.observability.AgentRequest;
import dev.langchain4j.agentic.observability.AgentResponse;
import dev.langchain4j.agentic.planner.AgentInstance;
import dev.langchain4j.agentic.scope.AgenticScope;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class AgentInvocation {
    private final List<AgentInvocation> nestedInvocations = Collections.synchronizedList(new ArrayList());
    private final AgentRequest agentRequest;
    private final LocalDateTime startTime;
    private AgentResponse agentResponse;
    private LocalDateTime finishTime;

    AgentInvocation(AgentRequest agentRequest) {
        this.agentRequest = agentRequest;
        this.startTime = LocalDateTime.now();
    }

    void finished(AgentResponse agentResponse) {
        this.agentResponse = agentResponse;
        this.finishTime = LocalDateTime.now();
    }

    void addNestedInvocation(AgentInvocation agentInvocation) {
        this.nestedInvocations.add(agentInvocation);
    }

    public boolean done() {
        return this.finishTime != null;
    }

    public LocalDateTime startTime() {
        return this.startTime;
    }

    public LocalDateTime finishTime() {
        return this.finishTime;
    }

    public Duration duration() {
        if (!this.done()) {
            throw new IllegalStateException("Agent call is not finished yet");
        }
        return Duration.between(this.startTime, this.finishTime);
    }

    public AgentInstance agent() {
        return this.agentRequest.agent();
    }

    public AgenticScope agenticScope() {
        return this.agentRequest.agenticScope();
    }

    public Map<String, Object> inputs() {
        return this.agentRequest.inputs();
    }

    public Object output() {
        if (!this.done()) {
            throw new IllegalStateException("Agent call is not finished yet");
        }
        return this.agentResponse.output();
    }

    public List<AgentInvocation> nestedInvocations() {
        return this.nestedInvocations;
    }

    public String toString() {
        return this.toString("");
    }

    private String toString(String prefix) {
        StringBuilder sb = new StringBuilder((String)prefix + "AgentInvocation{agent=" + this.agent().name() + ", startTime=" + String.valueOf(this.startTime) + ", finishTime=" + String.valueOf(this.finishTime) + ", duration=" + (String)(this.done() ? this.duration().toMillis() + " ms" : "in progress") + ", inputs=" + this.shortToString(this.inputs()) + ", output=" + (this.done() ? this.shortToString(this.output()) : "in progress") + "}");
        if (!this.nestedInvocations.isEmpty()) {
            prefix = ((String)prefix).isEmpty() ? "|=> " : "    " + (String)prefix;
            for (AgentInvocation nestedCall : this.nestedInvocations) {
                sb.append("\n").append(nestedCall.toString((String)prefix));
            }
        }
        return sb.toString();
    }

    private String shortToString(Object o) {
        if (o == null) {
            return "null";
        }
        String s = o.toString();
        return s.substring(0, Math.min(s.length(), 15)) + (s.length() > 15 ? "..." : "");
    }

    private String shortToString(Map<?, ?> map) {
        if (map.isEmpty()) {
            return "{}";
        }
        boolean first = true;
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        for (Map.Entry<?, ?> e : map.entrySet()) {
            if (first) {
                first = false;
            } else {
                sb.append(',').append(' ');
            }
            Object key = e.getKey();
            Object value = e.getValue();
            sb.append((Object)(key == this ? "(this Map)" : key));
            sb.append('=');
            sb.append(value == this ? "(this Map)" : this.shortToString(value));
        }
        return sb.append('}').toString();
    }
}

