/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.agentic.internal;

import dev.langchain4j.agentic.UntypedAgent;
import dev.langchain4j.agentic.agent.ErrorContext;
import dev.langchain4j.agentic.agent.ErrorRecoveryResult;
import dev.langchain4j.agentic.internal.AbstractServiceBuilder;
import dev.langchain4j.agentic.internal.AgentExecutor;
import dev.langchain4j.agentic.internal.AgentInvocationListener;
import dev.langchain4j.agentic.internal.AgentInvoker;
import dev.langchain4j.agentic.internal.AgentUtil;
import dev.langchain4j.agentic.internal.AgenticScopeOwner;
import dev.langchain4j.agentic.internal.InternalAgent;
import dev.langchain4j.agentic.observability.AgentListener;
import dev.langchain4j.agentic.observability.AgentListenerProvider;
import dev.langchain4j.agentic.observability.ListenerNotifierUtil;
import dev.langchain4j.agentic.planner.Action;
import dev.langchain4j.agentic.planner.AgentArgument;
import dev.langchain4j.agentic.planner.AgentInstance;
import dev.langchain4j.agentic.planner.AgenticSystemTopology;
import dev.langchain4j.agentic.planner.ChatMemoryAccessProvider;
import dev.langchain4j.agentic.planner.InitPlanningContext;
import dev.langchain4j.agentic.planner.Planner;
import dev.langchain4j.agentic.planner.PlanningContext;
import dev.langchain4j.agentic.scope.AgentInvocation;
import dev.langchain4j.agentic.scope.AgenticScope;
import dev.langchain4j.agentic.scope.AgenticScopeAccess;
import dev.langchain4j.agentic.scope.AgenticScopeRegistry;
import dev.langchain4j.agentic.scope.DefaultAgenticScope;
import dev.langchain4j.agentic.scope.ResultWithAgenticScope;
import dev.langchain4j.internal.DefaultExecutorProvider;
import dev.langchain4j.service.MemoryId;
import dev.langchain4j.service.ParameterNameResolver;
import dev.langchain4j.service.memory.ChatMemoryAccess;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class PlannerBasedInvocationHandler
implements InvocationHandler,
AgentInstance,
InternalAgent {
    private final Executor executor;
    private final Function<AgenticScope, Object> output;
    protected final AgentListener agentListener;
    private final Consumer<AgenticScope> beforeCall;
    private final DefaultAgenticScope agenticScope;
    private final Function<ErrorContext, ErrorRecoveryResult> errorHandler;
    private final AtomicReference<AgenticScopeRegistry> agenticScopeRegistry = new AtomicReference();
    private final AbstractServiceBuilder<?, ?> service;
    private final Supplier<Planner> plannerSupplier;
    private final Planner defaultPlannerInstance;
    private final Class<?> type;
    private final String name;
    private final String description;
    private final Type outputType;
    private final String outputKey;
    private final List<AgentArgument> arguments;
    private final List<AgentInstance> subagents;
    private String agentId;
    private AgentInstance parent;

    public PlannerBasedInvocationHandler(AbstractServiceBuilder<?, ?> service, Supplier<Planner> plannerSupplier) {
        this(service, null, service.name, plannerSupplier, null);
        for (int i = 0; i < service.subagents.size(); ++i) {
            service.subagents.get(i).setParent(this, i);
        }
        AgentUtil.agenticSystemDataTypes(this);
    }

    private PlannerBasedInvocationHandler(AbstractServiceBuilder<?, ?> service, AgentInstance parent, String agentId, Supplier<Planner> plannerSupplier, DefaultAgenticScope agenticScope) {
        this.service = service;
        this.agentId = agentId;
        this.parent = parent;
        this.output = service.output;
        this.executor = service.executor;
        this.beforeCall = service.beforeCall;
        this.errorHandler = service.errorHandler;
        this.agentListener = service.agentListener;
        this.plannerSupplier = plannerSupplier;
        this.defaultPlannerInstance = plannerSupplier.get();
        this.agenticScope = agenticScope;
        this.type = service.agentServiceClass;
        this.name = service.name;
        this.description = service.description;
        this.outputType = service.agentReturnType();
        this.outputKey = service.outputKey;
        this.arguments = service.agenticMethod != null ? AgentUtil.argumentsFromMethod(service.agenticMethod) : List.of();
        this.subagents = service.subagents.stream().map(AgentInstance.class::cast).toList();
    }

    public AgenticScopeOwner withAgenticScope(DefaultAgenticScope agenticScope) {
        return (AgenticScopeOwner)Proxy.newProxyInstance(this.type.getClassLoader(), new Class[]{this.type, AgentInstance.class, AgentListenerProvider.class, AgenticScopeOwner.class}, (InvocationHandler)new PlannerBasedInvocationHandler(this.service, this.parent, this.agentId, this.plannerSupplier, agenticScope));
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Exception {
        AgenticScopeRegistry registry = this.agenticScopeRegistry();
        if (method.getDeclaringClass() == AgenticScopeOwner.class) {
            return switch (method.getName()) {
                case "withAgenticScope" -> this.withAgenticScope((DefaultAgenticScope)args[0]);
                case "registry" -> registry;
                default -> throw new UnsupportedOperationException("Unknown method on AgenticScopeOwner class : " + method.getName());
            };
        }
        if (method.getDeclaringClass() == AgenticScopeAccess.class) {
            return switch (method.getName()) {
                case "getAgenticScope" -> registry.get(args[0]);
                case "evictAgenticScope" -> registry.evict(args[0], this.agentListener);
                default -> throw new UnsupportedOperationException("Unknown method on AgenticScopeAccess class : " + method.getName());
            };
        }
        if (method.getDeclaringClass() == AgentInstance.class || method.getDeclaringClass() == InternalAgent.class) {
            return method.invoke((Object)Proxy.getInvocationHandler(proxy), args);
        }
        if (method.getDeclaringClass() == AgentListenerProvider.class) {
            return this.agentListener;
        }
        if (method.getDeclaringClass() == Object.class) {
            return switch (method.getName()) {
                case "toString" -> this.service.serviceType() + "<" + this.type.getSimpleName() + ">";
                case "hashCode" -> System.identityHashCode(this);
                default -> throw new UnsupportedOperationException("Unknown method on Object class : " + method.getName());
            };
        }
        if (method.getDeclaringClass() == ChatMemoryAccess.class) {
            Object memoryId = args[0];
            return this.accessChatMemory(this.getOrCreateAgenticScope(registry, memoryId), method.getName(), memoryId);
        }
        return this.executeAgentMethod(registry, method, args);
    }

    private AgenticScopeRegistry agenticScopeRegistry() {
        if (this.isRootCall()) {
            this.agenticScopeRegistry.compareAndSet(null, new AgenticScopeRegistry(this.type.getName()));
        }
        return this.agenticScopeRegistry.get();
    }

    private Object executeAgentMethod(AgenticScopeRegistry registry, Method method, Object[] args) {
        Object output;
        Map<String, Object> namedArgs;
        DefaultAgenticScope currentScope = this.currentAgenticScope(registry, method, args);
        PlannerBasedInvocationHandler.writeAgenticScope(currentScope, method, args);
        this.beforeCall.accept(currentScope);
        Map<String, Object> map = namedArgs = this.isRootCall() ? PlannerBasedInvocationHandler.argToMap(method, args) : null;
        if (this.isRootCall()) {
            currentScope.setListener(this.agentListener);
            currentScope.rootCallStarted(registry);
            ListenerNotifierUtil.beforeAgentInvocation(this.agentListener, currentScope, this, namedArgs);
        }
        Planner planner = this.plannerSupplier.get();
        planner.init(new InitPlanningContext(currentScope, this, this.subagents));
        Object result = new PlannerLoop(planner, currentScope).loop();
        Object object = output = this.outputKey != null ? currentScope.readState(this.outputKey) : result;
        if (this.isRootCall()) {
            ListenerNotifierUtil.afterAgentInvocation(this.agentListener, currentScope, this, namedArgs, output);
            currentScope.rootCallEnded(registry);
            currentScope.setListener(null);
        }
        return method.getReturnType().equals(ResultWithAgenticScope.class) ? new ResultWithAgenticScope<Object>(currentScope, output) : output;
    }

    private static Map<String, Object> argToMap(Method method, Object[] args) {
        if (method.getParameterCount() == 1 && Map.class.isAssignableFrom(method.getParameters()[0].getType())) {
            return (Map)args[0];
        }
        if (args == null || args.length == 0) {
            return Map.of();
        }
        HashMap<String, Object> namedArgs = new HashMap<String, Object>();
        for (int i = 0; i < args.length; ++i) {
            namedArgs.put(ParameterNameResolver.name((Parameter)method.getParameters()[i]), args[i]);
        }
        return namedArgs;
    }

    @Override
    public Class<?> type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String agentId() {
        return this.agentId;
    }

    @Override
    public String description() {
        return this.description;
    }

    @Override
    public Type outputType() {
        return this.outputType;
    }

    @Override
    public String outputKey() {
        return this.outputKey;
    }

    @Override
    public boolean async() {
        return false;
    }

    @Override
    public List<AgentArgument> arguments() {
        return this.arguments;
    }

    @Override
    public AgentInstance parent() {
        return this.parent;
    }

    @Override
    public void setParent(AgentInstance parent) {
        this.parent = parent;
    }

    @Override
    public void appendId(String idSuffix) {
        this.agentId = this.agentId + idSuffix;
    }

    @Override
    public List<AgentInstance> subagents() {
        return this.subagents;
    }

    @Override
    public AgenticSystemTopology topology() {
        return this.defaultPlannerInstance.topology();
    }

    private boolean isRootCall() {
        return this.agenticScope == null;
    }

    private static void writeAgenticScope(DefaultAgenticScope agenticScope, Method method, Object[] args) {
        if (method.getDeclaringClass() == UntypedAgent.class) {
            agenticScope.writeStates((Map)args[0]);
        } else {
            Parameter[] parameters = method.getParameters();
            for (int i = 0; i < parameters.length; ++i) {
                int index = i;
                AgentInvoker.optionalParameterName(parameters[i]).ifPresent(argName -> agenticScope.writeState((String)argName, args[index]));
            }
        }
    }

    private DefaultAgenticScope currentAgenticScope(AgenticScopeRegistry registry, Method method, Object[] args) {
        if (this.agenticScope != null) {
            return this.agenticScope;
        }
        Object memoryId = this.memoryId(method, args);
        DefaultAgenticScope newAgenticScope = memoryId != null ? this.getOrCreateAgenticScope(registry, memoryId) : this.createEphemeralAgenticScope(registry);
        return newAgenticScope.withErrorHandler(this.errorHandler);
    }

    private DefaultAgenticScope createEphemeralAgenticScope(AgenticScopeRegistry registry) {
        DefaultAgenticScope agenticScope = registry.createEphemeralAgenticScope();
        ListenerNotifierUtil.afterAgenticScopeCreated(this.agentListener, agenticScope);
        return agenticScope;
    }

    private DefaultAgenticScope getOrCreateAgenticScope(AgenticScopeRegistry registry, Object memoryId) {
        DefaultAgenticScope agenticScope = registry.get(memoryId);
        if (agenticScope == null) {
            agenticScope = registry.create(memoryId);
            ListenerNotifierUtil.afterAgenticScopeCreated(this.agentListener, agenticScope);
        }
        return agenticScope;
    }

    private Object memoryId(Method method, Object[] args) {
        Parameter[] parameters = method.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            if (parameters[i].getAnnotation(MemoryId.class) == null) continue;
            return args[i];
        }
        return null;
    }

    private Object accessChatMemory(AgenticScope agenticScope, String methodName, Object memoryId) {
        ChatMemoryAccess chatMemoryAccess = ((ChatMemoryAccessProvider)((Object)this.defaultPlannerInstance)).chatMemoryAccess(agenticScope);
        return switch (methodName) {
            case "getChatMemory" -> chatMemoryAccess.getChatMemory(memoryId);
            case "evictChatMemory" -> Boolean.valueOf(chatMemoryAccess.evictChatMemory(memoryId));
            default -> throw new UnsupportedOperationException("Unknown method on ChatMemoryAccess class : " + methodName);
        };
    }

    private class PlannerLoop
    implements AgentInvocationListener {
        private final Planner planner;
        private final DefaultAgenticScope agenticScope;
        private Action nextAction = null;

        private PlannerLoop(Planner planner, DefaultAgenticScope agenticScope) {
            this.planner = planner;
            this.agenticScope = agenticScope;
        }

        public Object loop() {
            this.nextAction = this.planner.firstAction(new PlanningContext(this.agenticScope, null));
            block4: while (this.nextAction == null || !this.nextAction.isDone()) {
                if (this.nextAction == null) {
                    Thread.yield();
                    continue;
                }
                List<AgentExecutor> agents = ((Action.AgentCallAction)this.nextAction).agentsToCall();
                this.nextAction = null;
                switch (agents.size()) {
                    case 0: {
                        Thread.yield();
                        continue block4;
                    }
                    case 1: {
                        agents.get(0).execute(this.agenticScope, this);
                        continue block4;
                    }
                }
                this.parallelExecution(agents);
            }
            return this.result();
        }

        private void parallelExecution(List<AgentExecutor> agents) {
            ExecutorService exec = PlannerBasedInvocationHandler.this.executor != null ? PlannerBasedInvocationHandler.this.executor : DefaultExecutorProvider.getDefaultExecutorService();
            List<CompletableFuture> tasks = agents.stream().map(agentExecutor -> CompletableFuture.supplyAsync(() -> agentExecutor.execute(this.agenticScope, this), exec)).toList();
            try {
                for (Future future : tasks) {
                    future.get();
                }
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }

        private Object result() {
            Object result;
            Object object = result = PlannerBasedInvocationHandler.this.output != null ? PlannerBasedInvocationHandler.this.output.apply(this.agenticScope) : this.nextAction.result();
            if (PlannerBasedInvocationHandler.this.outputKey != null) {
                if (result != null) {
                    this.agenticScope.writeState(PlannerBasedInvocationHandler.this.outputKey, result);
                    return result;
                }
                return this.agenticScope.readState(PlannerBasedInvocationHandler.this.outputKey);
            }
            return result;
        }

        @Override
        public void onAgentInvoked(AgentInvocation agentInvocation) {
            this.nextAction = PlannerLoop.composeActions(this.nextAction, this.planner.nextAction(new PlanningContext(this.agenticScope, agentInvocation)));
        }

        private static Action composeActions(Action first, Action second) {
            if (first == null || first.isDone()) {
                return second;
            }
            if (second == null || second.isDone()) {
                return first;
            }
            ArrayList<AgentExecutor> agentsToCall = new ArrayList<AgentExecutor>();
            agentsToCall.addAll(((Action.AgentCallAction)first).agentsToCall());
            agentsToCall.addAll(((Action.AgentCallAction)second).agentsToCall());
            return new Action.AgentCallAction(agentsToCall);
        }
    }
}

