/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.agentic.internal;

import dev.langchain4j.agentic.internal.InternalAgent;
import dev.langchain4j.agentic.observability.AgentListener;
import dev.langchain4j.agentic.observability.AgentListenerProvider;
import dev.langchain4j.agentic.planner.AgentArgument;
import dev.langchain4j.agentic.planner.AgentInstance;
import dev.langchain4j.agentic.planner.AgenticSystemTopology;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;

public class NonAiAgentInstance
implements AgentInstance,
AgentListenerProvider,
InternalAgent {
    private final Class<?> type;
    private final String name;
    private final String description;
    private final Type outputType;
    private final String outputKey;
    private final boolean async;
    private final List<AgentArgument> arguments;
    private final AgentListener listener;
    private AgentInstance parent;
    private String agentId;

    public NonAiAgentInstance(Class<?> type, String name, String description, Type outputType, String outputKey, boolean async, List<AgentArgument> arguments, AgentListener listener) {
        this.type = type;
        this.name = name;
        this.agentId = name;
        this.description = description;
        this.outputType = outputType;
        this.outputKey = outputKey;
        this.async = async;
        this.arguments = arguments;
        this.listener = listener;
    }

    @Override
    public String agentId() {
        return this.agentId;
    }

    @Override
    public AgentInstance parent() {
        return this.parent;
    }

    @Override
    public List<AgentInstance> subagents() {
        return List.of();
    }

    @Override
    public AgenticSystemTopology topology() {
        return AgenticSystemTopology.SINGLE_AGENT;
    }

    @Override
    public Class<?> type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String description() {
        return this.description;
    }

    @Override
    public Type outputType() {
        return this.outputType;
    }

    @Override
    public String outputKey() {
        return this.outputKey;
    }

    @Override
    public boolean async() {
        return this.async;
    }

    @Override
    public List<AgentArgument> arguments() {
        return this.arguments;
    }

    @Override
    public AgentListener listener() {
        return this.listener;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        NonAiAgentInstance that = (NonAiAgentInstance)obj;
        return Objects.equals(this.type, that.type) && Objects.equals(this.name, that.name) && Objects.equals(this.description, that.description) && Objects.equals(this.outputType, that.outputType) && Objects.equals(this.outputKey, that.outputKey) && this.async == that.async && Objects.equals(this.arguments, that.arguments) && Objects.equals(this.listener, that.listener);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.name, this.description, this.outputType, this.outputKey, this.async, this.arguments, this.listener);
    }

    public String toString() {
        return "NonAiAgentInstance[type=" + String.valueOf(this.type) + ", name=" + this.name + ", description=" + this.description + ", outputType=" + String.valueOf(this.outputType) + ", outputKey=" + this.outputKey + ", async=" + this.async + ", arguments=" + String.valueOf(this.arguments) + ", listener=" + String.valueOf(this.listener) + "]";
    }

    @Override
    public void setParent(AgentInstance parent) {
        this.parent = parent;
    }

    @Override
    public void appendId(String idSuffix) {
        this.agentId = this.agentId + idSuffix;
    }
}

