/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.agentic.agent;

import dev.langchain4j.agentic.agent.AgentBuilder;
import dev.langchain4j.agentic.agent.ChatMessagesAccess;
import dev.langchain4j.agentic.internal.AgenticScopeOwner;
import dev.langchain4j.agentic.internal.InternalAgent;
import dev.langchain4j.agentic.internal.UserMessageRecorder;
import dev.langchain4j.agentic.observability.AgentListenerProvider;
import dev.langchain4j.agentic.planner.AgentArgument;
import dev.langchain4j.agentic.planner.AgentInstance;
import dev.langchain4j.agentic.planner.AgenticSystemTopology;
import dev.langchain4j.agentic.scope.DefaultAgenticScope;
import dev.langchain4j.service.AiServiceContext;
import dev.langchain4j.service.memory.ChatMemoryAccess;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.List;

public class AgentInvocationHandler
implements InvocationHandler,
InternalAgent {
    private final AiServiceContext context;
    private final AgentBuilder<?> builder;
    private final Object agent;
    private final UserMessageRecorder messageRecorder;
    private final boolean agenticScopeDependent;
    private String agentId;
    private AgentInstance parent;

    AgentInvocationHandler(AiServiceContext context, Object agent, AgentBuilder<?> builder, UserMessageRecorder messageRecorder, boolean agenticScopeDependent) {
        this.context = context;
        this.agent = agent;
        this.builder = builder;
        this.agentId = builder.name;
        this.messageRecorder = messageRecorder;
        this.agenticScopeDependent = agenticScopeDependent;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Exception {
        if (method.getDeclaringClass() == ChatMessagesAccess.class) {
            switch (method.getName()) {
                case "lastUserMessage": {
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown method on AgenticScopeOwner class : " + method.getName());
                }
            }
            return this.messageRecorder.lastUserMessage();
        }
        if (method.getDeclaringClass() == AgenticScopeOwner.class) {
            return switch (method.getName()) {
                case "withAgenticScope" -> {
                    if (!this.agenticScopeDependent) {
                        yield proxy;
                    }
                    Object agentProxy = ((DefaultAgenticScope)args[0]).getOrCreateAgent(this.agentId, this.builder::build);
                    AgentInvocationHandler agent = (AgentInvocationHandler)Proxy.getInvocationHandler(agentProxy);
                    agent.parent = this.parent;
                    agent.agentId = this.agentId;
                    yield agentProxy;
                }
                case "registry" -> throw new UnsupportedOperationException("AgenticScopeOwner's registry method can be used only on the root agent of an agentic system.");
                default -> throw new UnsupportedOperationException("Unknown method on AgenticScopeOwner class : " + method.getName());
            };
        }
        if (method.getDeclaringClass() == ChatMemoryAccess.class) {
            return switch (method.getName()) {
                case "getChatMemory" -> {
                    if (this.context.hasChatMemory() && ("default".equals(args[0]) || this.builder.hasNonDefaultChatMemory())) {
                        yield this.context.chatMemoryService.getChatMemory(args[0]);
                    }
                    yield null;
                }
                case "evictChatMemory" -> this.context.hasChatMemory() && this.context.chatMemoryService.evictChatMemory(args[0]) != null;
                default -> throw new UnsupportedOperationException("Unknown method on ChatMemoryAccess class : " + method.getName());
            };
        }
        if (method.getDeclaringClass() == AgentInstance.class || method.getDeclaringClass() == InternalAgent.class) {
            return method.invoke((Object)Proxy.getInvocationHandler(proxy), args);
        }
        if (method.getDeclaringClass() == AgentListenerProvider.class) {
            return this.builder.agentListener;
        }
        if (method.getDeclaringClass() == Object.class) {
            return switch (method.getName()) {
                case "toString" -> "Agent<" + this.builder.agentServiceClass.getSimpleName() + ">";
                case "hashCode" -> System.identityHashCode(this.agent);
                default -> throw new UnsupportedOperationException("Unknown method on Object class : " + method.getName());
            };
        }
        return method.invoke(this.agent, args);
    }

    @Override
    public void setParent(AgentInstance parent) {
        this.parent = parent;
    }

    @Override
    public void appendId(String idSuffix) {
        this.agentId = this.agentId + idSuffix;
    }

    @Override
    public Class<?> type() {
        return this.builder.agentServiceClass;
    }

    @Override
    public String name() {
        return this.builder.name;
    }

    @Override
    public String agentId() {
        return this.agentId;
    }

    @Override
    public String description() {
        return this.builder.description;
    }

    @Override
    public Type outputType() {
        return this.builder.agentReturnType;
    }

    @Override
    public String outputKey() {
        return this.builder.outputKey;
    }

    @Override
    public boolean async() {
        return this.builder.async;
    }

    @Override
    public List<AgentArgument> arguments() {
        return this.builder.arguments;
    }

    @Override
    public AgentInstance parent() {
        return this.parent;
    }

    @Override
    public List<AgentInstance> subagents() {
        return List.of();
    }

    @Override
    public AgenticSystemTopology topology() {
        return AgenticSystemTopology.SINGLE_AGENT;
    }
}

