/*
 * Decompiled with CFR 0.152.
 */
package dev.equo.solstice.p2;

import dev.equo.solstice.NestedJars;
import dev.equo.solstice.SerializableMisc;
import dev.equo.solstice.p2.FileMisc;
import dev.equo.solstice.p2.OfflineCache;
import dev.equo.solstice.p2.P2Model;
import dev.equo.solstice.p2.P2QueryResult;
import java.io.File;
import java.util.Optional;
import javax.annotation.Nullable;

class QueryCacheOnDisk {
    final File rootDir;
    final String key;
    private static final String VERSION = "version";
    private static final String VERSION_VALUE = "1";
    private static final String CONTENT = "content";

    QueryCacheOnDisk(File rootDir, P2Model model) {
        this.rootDir = rootDir;
        this.key = NestedJars.solsticeVersion() + model.hashCode();
        if (!FileMisc.readToken(rootDir, VERSION).equals(Optional.of(VERSION_VALUE))) {
            if (rootDir.exists()) {
                FileMisc.delete(rootDir);
            }
            FileMisc.mkdirs(rootDir);
            FileMisc.writeToken(rootDir, VERSION, VERSION_VALUE);
        }
    }

    @Nullable
    public P2QueryResult get() {
        File dir = new File(this.rootDir, OfflineCache.filenameSafe(this.key));
        if (dir.isDirectory()) {
            return SerializableMisc.fromFile(P2QueryResult.class, new File(dir, CONTENT));
        }
        return null;
    }

    public void put(P2QueryResult query) {
        File dir = new File(this.rootDir, OfflineCache.filenameSafe(this.key));
        FileMisc.mkdirs(dir);
        SerializableMisc.toFile(query, new File(dir, CONTENT));
    }
}

