/*
 * Decompiled with CFR 0.152.
 */
package dev.equo.solstice;

import dev.equo.solstice.ShimBundle;
import dev.equo.solstice.ShimBundleRevision;
import dev.equo.solstice.Unimplemented;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;

class ShimBundleWiring
extends Unimplemented.BundleWiring {
    private final ShimBundle bundle;

    ShimBundleWiring(ShimBundle bundle) {
        this.bundle = Objects.requireNonNull(bundle);
    }

    @Override
    public List<BundleWire> getRequiredWires(String namespace) {
        if (namespace.equals("osgi.wiring.host") && this.bundle.manifest.isFragment()) {
            final ShimBundle host = this.bundle.getRootBundleContext().bundleForSymbolicName(this.bundle.manifest.fragmentHost());
            return Collections.singletonList(new Unimplemented.BundleWire(){

                @Override
                public BundleWiring getProviderWiring() {
                    return host.adapt(BundleWiring.class);
                }
            });
        }
        return Collections.emptyList();
    }

    @Override
    public BundleRevision getRevision() {
        return new ShimBundleRevision(this.bundle);
    }

    @Override
    public Collection<String> listResources(String path, String filePattern, int options) {
        boolean recurse = (options & 1) == 1;
        ArrayList<String> asStrings = new ArrayList<String>();
        ShimBundleWiring.listResourcesHelper(asStrings, this.bundle, path, filePattern, recurse);
        return asStrings;
    }

    private static void listResourcesHelper(List<String> asStrings, ShimBundle bundle, String path, String filePattern, boolean recurse) {
        Enumeration<URL> urls = bundle.findEntries(path, filePattern, recurse);
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            asStrings.add(url.toExternalForm());
        }
        for (String required : bundle.manifest.totalRequiredBundles()) {
            ShimBundleWiring.listResourcesHelper(asStrings, bundle.getRootBundleContext().bundleForSymbolicName(required), path, filePattern, recurse);
        }
    }

    @Override
    public boolean isInUse() {
        return true;
    }

    @Override
    public List<BundleWire> getProvidedWires(String namespace) {
        return Collections.emptyList();
    }
}

