/*
 * Decompiled with CFR 0.152.
 */
package dev.ai4j.openai4j.chat;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import dev.ai4j.openai4j.chat.ContentType;
import dev.ai4j.openai4j.chat.ImageUrl;
import dev.ai4j.openai4j.chat.InputAudio;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public final class Content {
    @JsonProperty
    private final ContentType type;
    @JsonProperty
    private final String text;
    @JsonProperty
    private final ImageUrl imageUrl;
    @JsonProperty
    private final InputAudio inputAudio;

    public Content(Builder builder) {
        this.type = builder.type;
        this.text = builder.text;
        this.imageUrl = builder.imageUrl;
        this.inputAudio = builder.inputAudio;
    }

    public ContentType type() {
        return this.type;
    }

    public String text() {
        return this.text;
    }

    public ImageUrl imageUrl() {
        return this.imageUrl;
    }

    public InputAudio inputAudio() {
        return this.inputAudio;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Content && this.equalTo((Content)another);
    }

    private boolean equalTo(Content another) {
        return Objects.equals((Object)this.type, (Object)another.type) && Objects.equals(this.text, another.text) && Objects.equals(this.imageUrl, another.imageUrl) && Objects.equals(this.inputAudio, another.inputAudio);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode((Object)this.type);
        h += (h << 5) + Objects.hashCode(this.text);
        h += (h << 5) + Objects.hashCode(this.imageUrl);
        h += (h << 5) + Objects.hashCode(this.inputAudio);
        return h;
    }

    public String toString() {
        return "Content{type=" + (Object)((Object)this.type) + ", text=" + this.text + ", imageUrl=" + this.imageUrl + ", inputAudio=" + this.inputAudio + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonPOJOBuilder(withPrefix="")
    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static final class Builder {
        private ContentType type;
        private String text;
        private ImageUrl imageUrl;
        private InputAudio inputAudio;

        public Builder type(ContentType type) {
            this.type = type;
            return this;
        }

        public Builder text(String text) {
            this.text = text;
            return this;
        }

        public Builder imageUrl(ImageUrl imageUrl) {
            this.imageUrl = imageUrl;
            return this;
        }

        public Builder inputAudio(InputAudio inputAudio) {
            this.inputAudio = inputAudio;
            return this;
        }

        public Content build() {
            return new Content(this);
        }
    }
}

