/*
 * Decompiled with CFR 0.152.
 */
package dev.ai4j.openai4j;

import dev.ai4j.openai4j.LogLevel;
import dev.ai4j.openai4j.RequestLoggingInterceptor;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ResponseLoggingInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(ResponseLoggingInterceptor.class);
    private LogLevel logLevel = LogLevel.DEBUG;

    public ResponseLoggingInterceptor() {
    }

    public ResponseLoggingInterceptor(LogLevel logLevel) {
        this.logLevel = logLevel;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        Response response = chain.proceed(request);
        this.log(response);
        return response;
    }

    void log(Response response) {
        String message = "Response:\n- status code: {}\n- headers: {}\n- body: {}";
        try {
            switch (this.logLevel) {
                case INFO: {
                    this.logInfo(response, message);
                    break;
                }
                case WARN: {
                    this.logWarn(response, message);
                    break;
                }
                case ERROR: {
                    this.logError(response, message);
                    break;
                }
                default: {
                    this.logDebug(response, message);
                    break;
                }
            }
        }
        catch (IOException e) {
            log.warn("Failed to log response", (Throwable)e);
        }
    }

    private void logError(Response response, String message) throws IOException {
        log.error(message, new Object[]{response.code(), RequestLoggingInterceptor.inOneLine(response.headers()), this.getBody(response)});
    }

    private void logWarn(Response response, String message) throws IOException {
        log.warn(message, new Object[]{response.code(), RequestLoggingInterceptor.inOneLine(response.headers()), this.getBody(response)});
    }

    private void logInfo(Response response, String message) throws IOException {
        log.info(message, new Object[]{response.code(), RequestLoggingInterceptor.inOneLine(response.headers()), this.getBody(response)});
    }

    private void logDebug(Response response, String message) throws IOException {
        log.debug(message, new Object[]{response.code(), RequestLoggingInterceptor.inOneLine(response.headers()), this.getBody(response)});
    }

    private String getBody(Response response) throws IOException {
        if (this.isEventStream(response)) {
            return "[skipping response body due to streaming]";
        }
        return response.peekBody(Long.MAX_VALUE).string();
    }

    private boolean isEventStream(Response response) {
        String contentType = response.header("content-type");
        return contentType != null && contentType.contains("event-stream");
    }
}

