/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.gradle.tasks.download.org.apache.hc.core5.http2.ssl;

import de.undercouch.gradle.tasks.download.org.apache.hc.core5.concurrent.FutureCallback;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.http.HttpHost;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.http.URIScheme;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.http2.ssl.H2TlsSupport;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.net.NamedEndpoint;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.reactor.ssl.SSLBufferMode;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.reactor.ssl.SSLSessionInitializer;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.reactor.ssl.SSLSessionVerifier;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.reactor.ssl.TransportSecurityLayer;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.ssl.SSLContexts;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.util.Args;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.util.Timeout;
import java.net.SocketAddress;
import javax.net.ssl.SSLContext;

public class H2ClientTlsStrategy
implements TlsStrategy {
    private final SSLContext sslContext;
    private final SSLBufferMode sslBufferMode;
    private final SSLSessionInitializer initializer;
    private final SSLSessionVerifier verifier;

    public H2ClientTlsStrategy(SSLContext sslContext, SSLBufferMode sslBufferMode, SSLSessionInitializer initializer, SSLSessionVerifier verifier) {
        this.sslContext = Args.notNull(sslContext, "SSL context");
        this.sslBufferMode = sslBufferMode;
        this.initializer = initializer;
        this.verifier = verifier;
    }

    public H2ClientTlsStrategy(SSLContext sslContext, SSLSessionInitializer initializer, SSLSessionVerifier verifier) {
        this(sslContext, null, initializer, verifier);
    }

    public H2ClientTlsStrategy(SSLContext sslContext, SSLSessionVerifier verifier) {
        this(sslContext, null, null, verifier);
    }

    public H2ClientTlsStrategy(SSLContext sslContext) {
        this(sslContext, null, null, null);
    }

    public H2ClientTlsStrategy() {
        this(SSLContexts.createSystemDefault());
    }

    public H2ClientTlsStrategy(SSLSessionVerifier verifier) {
        this(SSLContexts.createSystemDefault(), null, null, verifier);
    }

    @Override
    public void upgrade(TransportSecurityLayer tlsSession, NamedEndpoint endpoint, Object attachment, Timeout handshakeTimeout, FutureCallback<TransportSecurityLayer> callback) {
        tlsSession.startTls(this.sslContext, endpoint, this.sslBufferMode, H2TlsSupport.enforceRequirements(attachment, this.initializer), this.verifier, handshakeTimeout, callback);
    }

    @Override
    @Deprecated
    public boolean upgrade(TransportSecurityLayer tlsSession, HttpHost host, SocketAddress localAddress, SocketAddress remoteAddress, Object attachment, Timeout handshakeTimeout) {
        String scheme;
        String string = scheme = host != null ? host.getSchemeName() : null;
        if (URIScheme.HTTPS.same(scheme)) {
            this.upgrade(tlsSession, host, attachment, handshakeTimeout, null);
            return true;
        }
        return false;
    }
}

