/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.gradle.tasks.download.internal;

import de.undercouch.gradle.tasks.download.org.apache.hc.core5.http.EntityDetails;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.http.HttpHost;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.http.HttpRequest;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.http.HttpRequestInterceptor;
import de.undercouch.gradle.tasks.download.org.apache.hc.core5.http.protocol.HttpContext;

public class RemoveSensitiveHeadersInterceptor
implements HttpRequestInterceptor {
    private final HttpHost originalHost;

    public RemoveSensitiveHeadersInterceptor(HttpHost originalHost) {
        this.originalHost = originalHost;
    }

    private int portOrDefault(int port, String scheme) {
        if (port != -1) {
            return port;
        }
        if ("https".equals(scheme)) {
            return 443;
        }
        if ("http".equals(scheme)) {
            return 80;
        }
        return -1;
    }

    @Override
    public void process(HttpRequest request, EntityDetails entity, HttpContext context) {
        int originalPort = this.portOrDefault(this.originalHost.getPort(), this.originalHost.getSchemeName());
        int requestPort = this.portOrDefault(request.getAuthority().getPort(), request.getScheme());
        if (request.getAuthority() == null || !request.getAuthority().getHostName().equals(this.originalHost.getHostName()) || requestPort != originalPort) {
            request.removeHeaders("Authorization");
            request.removeHeaders("Cookie");
            request.removeHeaders("Cookie2");
            request.removeHeaders("Proxy-Authorization");
            request.removeHeaders("WWW-Authenticate");
        }
    }
}

