/*
 * Decompiled with CFR 0.152.
 */
package de.smartics.maven.plugin.jboss.modules.util.classpath;

import de.smartics.maven.plugin.jboss.modules.util.classpath.AbstractProjectClassLoader;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.logging.Logger;

public class ProjectClassLoader
extends AbstractProjectClassLoader {
    private final List<File> rootDirectories;

    public ProjectClassLoader(List<File> rootDirectories) {
        this(Thread.currentThread().getContextClassLoader(), rootDirectories);
    }

    public ProjectClassLoader(Collection<String> rootDirectoryNames) {
        this(ProjectClassLoader.initDirectories(Logger.getLogger(ProjectClassLoader.class.getName()), rootDirectoryNames));
    }

    @Override
    protected URL findResource(String name) {
        for (File directoryOrArchive : this.rootDirectories) {
            try {
                if (directoryOrArchive.isDirectory()) {
                    File resourceFile = new File(directoryOrArchive, name);
                    if (!resourceFile.canRead()) continue;
                    return resourceFile.toURI().toURL();
                }
                String resourceName = name;
                int index = name.lastIndexOf(46);
                if (index != -1) {
                    resourceName = name.substring(0, index);
                }
                resourceName = resourceName.replace('/', '.');
                return this.loadResourceFromLibrary(resourceName, name, directoryOrArchive);
            }
            catch (IOException iOException) {
            }
        }
        return super.findResource(name);
    }

    @Override
    protected Enumeration<URL> findResources(final String name) {
        return new Enumeration<URL>(){
            private URL element;
            {
                this.element = ProjectClassLoader.this.findResource(name);
            }

            @Override
            public boolean hasMoreElements() {
                return this.element != null;
            }

            @Override
            public URL nextElement() {
                if (this.element != null) {
                    URL element = this.element;
                    this.element = null;
                    return element;
                }
                throw new NoSuchElementException();
            }
        };
    }

    public ProjectClassLoader(ClassLoader parent, Collection<String> rootDirectoryNames) {
        this(parent, ProjectClassLoader.initDirectories(Logger.getLogger(ProjectClassLoader.class.getName()), rootDirectoryNames));
    }

    public ProjectClassLoader(ClassLoader parent, List<File> rootDirectories) {
        super(parent);
        this.rootDirectories = Collections.unmodifiableList(rootDirectories);
    }

    private static List<File> initDirectories(Logger log, Collection<String> directoryNames) {
        ArrayList<File> directories = new ArrayList<File>(directoryNames.size());
        for (String directoryName : directoryNames) {
            File directory = new File(directoryName);
            if (directory.canRead() && (directory.isDirectory() || directory.isFile() && ProjectClassLoader.isArchive(directoryName))) {
                directories.add(directory);
                continue;
            }
            String message = "Cannot access '" + directoryName + "' as directory or Java archive. Ignoring as classpath root.";
            log.fine(message);
        }
        return directories;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        for (File directoryOrArchive : this.rootDirectories) {
            try {
                String fileName = name.replace('.', '/') + ".class";
                if (directoryOrArchive.isDirectory()) {
                    File classFile = new File(directoryOrArchive, fileName);
                    if (!classFile.canRead()) continue;
                    return this.loadClassFile(name, classFile);
                }
                return this.loadClassFromLibrary(name, fileName, directoryOrArchive);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        return super.findClass(name);
    }

    private static boolean isArchive(String root) throws NullPointerException {
        return root.endsWith(".jar") || root.endsWith(".zip");
    }
}

