/*
 * Decompiled with CFR 0.152.
 */
package de.smartics.maven.plugin.jboss.modules.util.classpath;

import de.smartics.maven.plugin.jboss.modules.util.classpath.ClassPathListing;
import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.logging.Logger;

public final class ClassPathListingFactory {
    private static final Logger LOG = Logger.getLogger(ClassPathListingFactory.class.getName());

    public ClassPathListing create() {
        Iterator<ClassPathListing> iterator = ServiceLoader.load(ClassPathListing.class).iterator();
        StringBuilder buffer = new StringBuilder(64);
        ClassPathListing instance = null;
        while (iterator.hasNext()) {
            try {
                if (instance != null) {
                    String implementation = iterator.next().getClass().getName();
                    buffer.append("\nDuplicated implementation rejected: " + implementation);
                    continue;
                }
                instance = iterator.next();
            }
            catch (ServiceConfigurationError e) {
                buffer.append("\nError encountered: ").append(e.getMessage());
            }
        }
        if (buffer.length() > 0) {
            LOG.warning("Problems encountered while fetching implementations of '" + ClassPathListing.class.getName() + "':" + buffer);
        }
        if (instance == null) {
            throw new IllegalStateException("Cannot create instance of implementation of '" + ClassPathListing.class.getName() + "'.");
        }
        return instance;
    }
}

