/*
 * Decompiled with CFR 0.152.
 */
package de.smartics.maven.plugin.jboss.modules.parser;

import de.smartics.maven.plugin.jboss.modules.descriptor.ApplyToDependencies;
import de.smartics.maven.plugin.jboss.modules.descriptor.ApplyToModule;
import de.smartics.maven.plugin.jboss.modules.descriptor.ArtifactClusion;
import de.smartics.maven.plugin.jboss.modules.descriptor.ArtifactMatcher;
import de.smartics.maven.plugin.jboss.modules.descriptor.DependenciesDescriptor;
import de.smartics.maven.plugin.jboss.modules.descriptor.Directives;
import de.smartics.maven.plugin.jboss.modules.descriptor.ModuleClusion;
import de.smartics.maven.plugin.jboss.modules.descriptor.ModuleDescriptor;
import de.smartics.maven.plugin.jboss.modules.descriptor.ModuleMatcher;
import de.smartics.maven.plugin.jboss.modules.descriptor.ModulesDescriptor;
import de.smartics.maven.plugin.jboss.modules.parser.AbstractArtifactClusionAdderV2;
import de.smartics.maven.plugin.jboss.modules.parser.AbstractModuleClusionAdderV2;
import java.util.List;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

final class ModulesDescriptorBuilderV2 {
    static final Namespace NS = Namespace.getNamespace((String)"http://smartics.de/ns/jboss-modules-descriptor/2");
    private final Document document;
    private final ModulesDescriptor modulesDescriptor;
    private ModuleDescriptor.Builder builder;

    ModulesDescriptorBuilderV2(String documentId, Document document) throws NullPointerException, IllegalArgumentException {
        assert (document != null) : "Document must not be 'null'.";
        this.document = document;
        this.modulesDescriptor = new ModulesDescriptor(documentId);
    }

    public ModulesDescriptor build() {
        Element rootElement = this.document.getRootElement();
        List moduleElements = rootElement.getChildren("module", NS);
        for (Element moduleElement : moduleElements) {
            this.parseModule(moduleElement);
        }
        return this.modulesDescriptor;
    }

    private void parseModule(Element moduleElement) {
        this.builder = new ModuleDescriptor.Builder();
        String moduleName = moduleElement.getAttributeValue("name");
        String slot = moduleElement.getAttributeValue("slot");
        this.builder.withName(moduleName);
        this.builder.withSlot(slot);
        this.parseDirectives(moduleElement);
        this.parseMatch(moduleElement);
        this.parseApplyToDependencies(moduleElement);
        this.parseApplyToModule(moduleElement);
        ModuleDescriptor descriptor = this.builder.build();
        this.modulesDescriptor.addDescriptor(descriptor);
    }

    private void parseDirectives(Element directivesElement) {
        if (directivesElement == null) {
            return;
        }
        Directives.Builder builder = new Directives.Builder();
        String skip = directivesElement.getAttributeValue("skip");
        builder.withSkip(skip);
        String inheritSlot = directivesElement.getAttributeValue("inherit-slot");
        builder.withInheritSlot(inheritSlot);
        Directives directives = builder.build();
        this.builder.with(directives);
    }

    private void parseMatch(Element matchElement) {
        if (matchElement == null) {
            return;
        }
        final ArtifactMatcher.Builder builder = new ArtifactMatcher.Builder();
        new AbstractArtifactClusionAdderV2("includes", "include"){

            @Override
            public void add(ArtifactClusion clusion) {
                builder.addInclude(clusion);
            }
        }.addClusions(matchElement);
        new AbstractArtifactClusionAdderV2("excludes", "exclude"){

            @Override
            public void add(ArtifactClusion clusion) {
                builder.addExclude(clusion);
            }
        }.addClusions(matchElement);
        ArtifactMatcher matcher = builder.build();
        this.builder.with(matcher);
    }

    private void parseApplyToDependencies(Element applyToDependenciesElement) {
        if (applyToDependenciesElement == null) {
            return;
        }
        ApplyToDependencies.Builder builder = new ApplyToDependencies.Builder();
        List dependenciesElements = applyToDependenciesElement.getChildren("apply-to-dependencies", NS);
        for (Element dependenciesElement : dependenciesElements) {
            DependenciesDescriptor.Builder dependencyBuilder = new DependenciesDescriptor.Builder();
            this.parseMatcher(dependencyBuilder, dependenciesElement);
            this.parseApply(dependencyBuilder, dependenciesElement);
            DependenciesDescriptor dependencies = dependencyBuilder.build();
            builder.add(dependencies);
        }
        ApplyToDependencies applyToDependencies = builder.build();
        this.builder.with(applyToDependencies);
    }

    private void parseMatcher(DependenciesDescriptor.Builder dependencyBuilder, Element dependenciesElement) {
        if (dependenciesElement == null) {
            return;
        }
        final ModuleMatcher.Builder builder = new ModuleMatcher.Builder();
        new AbstractModuleClusionAdderV2("includes", "include"){

            @Override
            public void add(ModuleClusion clusion) {
                builder.addInclude(clusion);
            }
        }.addClusions(dependenciesElement);
        new AbstractModuleClusionAdderV2("excludes", "exclude"){

            @Override
            public void add(ModuleClusion clusion) {
                builder.addExclude(clusion);
            }
        }.addClusions(dependenciesElement);
        ModuleMatcher matcher = builder.build();
        dependencyBuilder.with(matcher);
    }

    private void parseApply(DependenciesDescriptor.Builder builder, Element dependenciesElement) {
        Element exportElement;
        if (dependenciesElement == null) {
            return;
        }
        String slot = dependenciesElement.getAttributeValue("slot");
        String skip = dependenciesElement.getAttributeValue("skip");
        String export = dependenciesElement.getAttributeValue("export");
        String services = dependenciesElement.getAttributeValue("services");
        String optional = dependenciesElement.getAttributeValue("optional");
        builder.withSlot(slot);
        builder.withSkip(skip);
        builder.withExport(export);
        builder.withServices(services);
        builder.withOptional(optional);
        XMLOutputter outputter = new XMLOutputter(Format.getCompactFormat());
        Element importElement = dependenciesElement.getChild("imports", NS);
        if (importElement != null) {
            String imports = outputter.outputString(importElement);
            builder.withImportsXml(imports);
        }
        if ((exportElement = dependenciesElement.getChild("exports", NS)) != null) {
            String exports = outputter.outputString(exportElement);
            builder.withExportsXml(exports);
        }
    }

    private void parseApplyToModule(Element applyToModuleElement) {
        if (applyToModuleElement == null) {
            return;
        }
        ApplyToModule.Builder mBuilder = new ApplyToModule.Builder();
        XMLOutputter outputter = new XMLOutputter(Format.getCompactFormat());
        for (Element child : applyToModuleElement.getChildren()) {
            this.handleChild(mBuilder, outputter, child);
        }
        this.builder.with(mBuilder.build());
    }

    private void handleChild(ApplyToModule.Builder mBuilder, XMLOutputter outputter, Element child) {
        String elementName = child.getName();
        if ("dependencies".equals(elementName)) {
            this.handleDependencies(mBuilder, outputter, child);
        } else if ("properties".equals(elementName)) {
            for (Element propertyElement : child.getChildren("property", NS)) {
                String name = propertyElement.getAttributeValue("name");
                String fragment = outputter.outputString(propertyElement);
                mBuilder.addPropertyXml(name, fragment);
            }
        } else if ("exports".equals(elementName)) {
            String fragment = outputter.outputString(child);
            mBuilder.withExportsXml(fragment);
        } else if ("main-class".equals(elementName)) {
            String fragment = outputter.outputString(child);
            mBuilder.withMainClassXml(fragment);
        } else if ("resource-root".equals(elementName)) {
            String fragment = outputter.outputString(child);
            mBuilder.addResourceRootXml(fragment);
        }
    }

    private void handleDependencies(ApplyToModule.Builder mBuilder, XMLOutputter outputter, Element child) {
        int nonModuleCounter = 0;
        for (Element childElement : child.getChildren()) {
            String childElementName = childElement.getName();
            String name = "module".equals(childElementName) ? childElement.getAttributeValue("name") : "non-module@" + ++nonModuleCounter;
            String fragment = outputter.outputString(childElement);
            mBuilder.addDependencyXml(name, fragment);
        }
    }
}

