/*
 * Decompiled with CFR 0.152.
 */
package de.smartics.maven.plugin.jboss.modules.domain;

import edu.emory.mathcs.backport.java.util.Arrays;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.eclipse.aether.artifact.Artifact;

public enum SlotStrategy {
    MAIN("main"),
    VERSION_MAJOR("version-major");

    public static final String MAIN_SLOT = "main";
    private String id;

    private SlotStrategy(String id) {
        this.id = id;
    }

    public static SlotStrategy fromString(String id) throws IllegalArgumentException {
        for (SlotStrategy strategy : SlotStrategy.values()) {
            if (!id.equals(strategy.id)) continue;
            return strategy;
        }
        throw new IllegalArgumentException(String.format("Invalid slot strategy '%s'. Allowed values are: %s", id, Arrays.toString((Object[])SlotStrategy.values())));
    }

    public String toString() {
        return this.id;
    }

    public String calcSlot(Artifact artifact, String defaultSlot) {
        if (this == VERSION_MAJOR) {
            String versionString = this.calcVersion(artifact);
            DefaultArtifactVersion version = new DefaultArtifactVersion(versionString);
            int majorVersion = version.getMajorVersion();
            String slot = !StringUtils.isBlank((String)defaultSlot) && !MAIN_SLOT.equals(defaultSlot) ? defaultSlot + majorVersion : String.valueOf(majorVersion);
            return slot;
        }
        return StringUtils.isBlank((String)defaultSlot) ? MAIN_SLOT : defaultSlot;
    }

    public String calcSlot(String defaultSlot, String moduleSlot, Artifact artifact) {
        String fallBackSlot = StringUtils.isBlank((String)moduleSlot) ? defaultSlot : moduleSlot;
        String slot = this.calcSlot(artifact, fallBackSlot);
        return slot;
    }

    private String calcVersion(Artifact artifact) {
        if (artifact != null) {
            return artifact.getVersion();
        }
        return "VersionX";
    }
}

