/*
 * Decompiled with CFR 0.152.
 */
package de.smartics.maven.plugin.jboss.modules.descriptor;

import de.smartics.maven.plugin.jboss.modules.descriptor.ModuleDescriptor;
import de.smartics.maven.plugin.jboss.modules.util.Arg;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public final class ModulesDescriptor {
    private final String modulesId;
    private final List<ModuleDescriptor> descriptors = new ArrayList<ModuleDescriptor>();

    public ModulesDescriptor(String modulesId) {
        this.modulesId = Arg.checkNotBlank("modulesId", modulesId);
    }

    public String getModulesId() {
        return this.modulesId;
    }

    public void addDescriptor(ModuleDescriptor descriptor) throws NullPointerException {
        this.descriptors.add(Arg.checkNotNull("descriptor", descriptor));
    }

    public List<ModuleDescriptor> getDescriptors() {
        return Collections.unmodifiableList(this.descriptors);
    }

    public void applyDefaultSlot(String slot) {
        for (ModuleDescriptor descriptor : this.descriptors) {
            descriptor.applySlot(slot);
        }
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE, (boolean)false, null);
    }
}

