/*
 * Decompiled with CFR 0.152.
 */
package de.smartics.maven.plugin.jboss.modules.descriptor;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public final class Directives {
    private Boolean skip;
    private Boolean inheritSlot;

    private Directives(Builder builder) {
        this.skip = builder.skip;
        this.inheritSlot = builder.inheritSlot;
    }

    public Boolean getSkip() {
        return this.skip;
    }

    public Boolean getInheritSlot() {
        return this.inheritSlot;
    }

    public void merge(Directives directives) {
        this.skip = this.skip | directives.skip;
        this.inheritSlot = this.inheritSlot | directives.inheritSlot;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE, (boolean)false, null);
    }

    public static final class Builder {
        private Boolean skip = Boolean.FALSE;
        private Boolean inheritSlot = Boolean.TRUE;

        public Builder withSkip(String skip) {
            if (StringUtils.isNotBlank((String)skip)) {
                this.skip = Boolean.parseBoolean(skip);
            }
            return this;
        }

        public Builder withInheritSlot(String inheritSlot) {
            if (StringUtils.isNotBlank((String)inheritSlot)) {
                this.inheritSlot = Boolean.parseBoolean(inheritSlot);
            }
            return this;
        }

        public Directives build() {
            return new Directives(this);
        }
    }
}

