/*
 * Decompiled with CFR 0.152.
 */
package de.smartics.maven.plugin.jboss.modules.descriptor;

import de.smartics.maven.plugin.jboss.modules.descriptor.ArtifactClusion;
import de.smartics.maven.plugin.jboss.modules.domain.MatchContext;
import de.smartics.maven.plugin.jboss.modules.domain.matching.DelegationMatchContext;
import de.smartics.maven.plugin.jboss.modules.domain.matching.SingleMatchContext;
import de.smartics.maven.plugin.jboss.modules.util.Arg;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.eclipse.aether.artifact.Artifact;

public final class ArtifactMatcher {
    private final List<ArtifactClusion> includes;
    private final List<ArtifactClusion> excludes;

    private ArtifactMatcher(Builder builder) {
        this.includes = builder.includes;
        this.excludes = builder.excludes;
    }

    public List<ArtifactClusion> getIncludes() {
        return this.includes;
    }

    public List<ArtifactClusion> getExcludes() {
        return this.excludes;
    }

    public MatchContext match(Artifact artifact) {
        boolean result;
        MatchContext includesContext = this.cludes(this.includes, artifact);
        MatchContext excludesContext = this.cludes(this.excludes, artifact);
        boolean bl = result = includesContext.isMatched() && !excludesContext.isMatched();
        if (includesContext.isMatched()) {
            return new DelegationMatchContext(result, includesContext);
        }
        return new SingleMatchContext(result, null);
    }

    public String findFilter(Artifact artifact) {
        ArtifactClusion clusion;
        MatchContext matchResult = this.match(artifact);
        if (matchResult != null && matchResult.isMatched() && (clusion = matchResult.getClusion()) != null) {
            return clusion.getFilter();
        }
        return null;
    }

    private MatchContext cludes(List<ArtifactClusion> clusions, Artifact artifact) {
        if (clusions != null) {
            for (ArtifactClusion clusion : clusions) {
                MatchContext matchContext = clusion.matches(artifact);
                if (!matchContext.isMatched()) continue;
                return matchContext;
            }
        }
        return new SingleMatchContext(false, null);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE, (boolean)false, null);
    }

    public static final class Builder {
        private final List<ArtifactClusion> includes = new ArrayList<ArtifactClusion>();
        private final List<ArtifactClusion> excludes = new ArrayList<ArtifactClusion>();

        public void addInclude(ArtifactClusion include) throws NullPointerException {
            this.includes.add(Arg.checkNotNull("include", include));
        }

        public void addExclude(ArtifactClusion exclude) throws NullPointerException {
            this.excludes.add(Arg.checkNotNull("exclude", exclude));
        }

        public ArtifactMatcher build() {
            return new ArtifactMatcher(this);
        }
    }
}

