/*
 * Decompiled with CFR 0.152.
 */
package de.smartics.maven.plugin.jboss.modules.descriptor;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public final class ApplyToModule {
    private String mainClassXml;
    private final Map<String, String> propertiesXml;
    private final Map<String, String> dependenciesXml;
    private String exportsXml;
    private final List<String> resourceRootsXml;

    private ApplyToModule(Builder builder) {
        this.mainClassXml = builder.mainClassXml;
        this.propertiesXml = builder.propertiesXml;
        this.dependenciesXml = builder.dependenciesXml;
        this.exportsXml = builder.exportsXml;
        this.resourceRootsXml = builder.resourceRootsXml;
    }

    public String getMainClassXml() {
        return this.mainClassXml;
    }

    public List<String> getPropertiesXml() {
        return new ArrayList<String>(this.propertiesXml.values());
    }

    public List<String> getDependenciesXml() {
        return new ArrayList<String>(this.dependenciesXml.values());
    }

    public List<String> getResourceRootsXml() {
        return new ArrayList<String>(this.resourceRootsXml);
    }

    public String getExportsXml() {
        return this.exportsXml;
    }

    public void merge(ApplyToModule applyToModule) {
        this.mergeMainClass(applyToModule);
        this.mergeExports(applyToModule);
        this.mergeResourceRootsXML(applyToModule);
        this.merge("properties", this.propertiesXml, applyToModule.propertiesXml);
        this.merge("dependencies", this.dependenciesXml, applyToModule.dependenciesXml);
    }

    private void mergeResourceRootsXML(ApplyToModule applyToModule) {
        for (String value : new ArrayList<String>(applyToModule.resourceRootsXml)) {
            if (this.resourceRootsXml.contains(value)) continue;
            this.resourceRootsXml.add(value);
        }
    }

    private void mergeMainClass(ApplyToModule applyToModule) {
        if (this.mainClassXml != null && applyToModule.mainClassXml != null && !this.mainClassXml.equals(applyToModule.mainClassXml)) {
            throw new IllegalStateException(String.format("Cannot merge differen main class information: %s differs from %s.", this.mainClassXml, applyToModule.mainClassXml));
        }
        if (this.mainClassXml == null) {
            this.mainClassXml = applyToModule.mainClassXml;
        }
    }

    private void mergeExports(ApplyToModule applyToModule) {
        if (this.exportsXml != null && applyToModule.exportsXml != null && !this.exportsXml.equals(applyToModule.exportsXml)) {
            throw new IllegalStateException(String.format("Cannot merge differen main class information: %s differs from %s.", this.exportsXml, applyToModule.exportsXml));
        }
        if (this.exportsXml == null) {
            this.exportsXml = applyToModule.exportsXml;
        }
    }

    private void merge(String id, Map<String, String> targetMap, Map<String, String> sourceAap) {
        for (Map.Entry<String, String> entry : sourceAap.entrySet()) {
            String name = entry.getKey();
            String xml = entry.getValue();
            String storedXml = targetMap.get(name);
            if (storedXml == null) {
                targetMap.put(name, xml);
                continue;
            }
            if (storedXml.equals(xml)) continue;
        }
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE, (boolean)false, null);
    }

    public static final class Builder {
        private String mainClassXml;
        private final Map<String, String> propertiesXml = new LinkedHashMap<String, String>();
        private final Map<String, String> dependenciesXml = new LinkedHashMap<String, String>();
        private String exportsXml;
        private final List<String> resourceRootsXml = new LinkedList<String>();

        public Builder withMainClassXml(String fragment) {
            this.mainClassXml = fragment;
            return this;
        }

        public void addPropertyXml(String name, String fragment) {
            this.propertiesXml.put(name, fragment);
        }

        public void addResourceRootXml(String value) {
            if (!this.resourceRootsXml.contains(value)) {
                this.resourceRootsXml.add(value);
            }
        }

        public void addDependencyXml(String moduleName, String xmlFragment) {
            this.dependenciesXml.put(moduleName, xmlFragment);
        }

        public Builder withExportsXml(String fragment) {
            this.exportsXml = fragment;
            return this;
        }

        public ApplyToModule build() {
            return new ApplyToModule(this);
        }
    }
}

