/*
 * Decompiled with CFR 0.152.
 */
package de.neuland.jade4j;

import com.googlecode.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import de.neuland.jade4j.Jade4J;
import de.neuland.jade4j.exceptions.JadeCompilerException;
import de.neuland.jade4j.exceptions.JadeException;
import de.neuland.jade4j.expression.ExpressionHandler;
import de.neuland.jade4j.expression.JexlExpressionHandler;
import de.neuland.jade4j.filter.CDATAFilter;
import de.neuland.jade4j.filter.CssFilter;
import de.neuland.jade4j.filter.Filter;
import de.neuland.jade4j.filter.JsFilter;
import de.neuland.jade4j.model.JadeModel;
import de.neuland.jade4j.parser.Parser;
import de.neuland.jade4j.parser.node.Node;
import de.neuland.jade4j.template.FileTemplateLoader;
import de.neuland.jade4j.template.JadeTemplate;
import de.neuland.jade4j.template.TemplateLoader;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;

public class JadeConfiguration {
    private static final String FILTER_CDATA = "cdata";
    private static final String FILTER_STYLE = "css";
    private static final String FILTER_SCRIPT = "js";
    private boolean prettyPrint = false;
    private boolean caching = true;
    private Jade4J.Mode mode = Jade4J.Mode.HTML;
    private Map<String, Filter> filters = new HashMap<String, Filter>();
    private Map<String, Object> sharedVariables = new HashMap<String, Object>();
    private TemplateLoader templateLoader = new FileTemplateLoader("", "UTF-8");
    private ExpressionHandler expressionHandler = new JexlExpressionHandler();
    protected static final int MAX_ENTRIES = 1000;
    private Map<String, JadeTemplate> cache = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(1001L).build();
    private Map<String, String> lockCache = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(1001L).build();

    public JadeConfiguration() {
        this.setFilter(FILTER_CDATA, new CDATAFilter());
        this.setFilter(FILTER_SCRIPT, new JsFilter());
        this.setFilter(FILTER_STYLE, new CssFilter());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JadeTemplate getTemplate(String name) throws IOException, JadeException {
        if (this.caching) {
            String key;
            long lastModified = this.templateLoader.getLastModified(name);
            JadeTemplate template = this.cache.get(this.getKeyValue(name, lastModified));
            if (template != null) {
                return template;
            }
            String string = key = this.getCachedKey(name, lastModified);
            synchronized (string) {
                JadeTemplate newTemplate = this.createTemplate(name);
                this.cache.put(key, newTemplate);
                return newTemplate;
            }
        }
        return this.createTemplate(name);
    }

    private synchronized String getCachedKey(String name, long lastModified) {
        String cachedKey;
        String key = this.getKeyValue(name, lastModified);
        if (key.equals(cachedKey = this.lockCache.get(name))) {
            return cachedKey;
        }
        if (cachedKey != null) {
            this.cache.remove(cachedKey);
        }
        this.lockCache.put(name, key);
        return key;
    }

    private String getKeyValue(String name, long lastModified) {
        return name + "-" + lastModified;
    }

    public void renderTemplate(JadeTemplate template, Map<String, Object> model, Writer writer) throws JadeCompilerException {
        JadeModel jadeModel = new JadeModel(this.sharedVariables);
        for (String filterName : this.filters.keySet()) {
            jadeModel.addFilter(filterName, this.filters.get(filterName));
        }
        jadeModel.putAll((Map<? extends String, ? extends Object>)model);
        template.process(jadeModel, writer);
    }

    public String renderTemplate(JadeTemplate template, Map<String, Object> model) throws JadeCompilerException {
        StringWriter writer = new StringWriter();
        this.renderTemplate(template, model, writer);
        return writer.toString();
    }

    private JadeTemplate createTemplate(String name) throws JadeException, IOException {
        JadeTemplate template = new JadeTemplate();
        Parser parser = new Parser(name, this.templateLoader, this.expressionHandler);
        Node root = parser.parse();
        template.setTemplateLoader(this.templateLoader);
        template.setExpressionHandler(this.expressionHandler);
        template.setRootNode(root);
        template.setPrettyPrint(this.prettyPrint);
        template.setMode(this.getMode());
        return template;
    }

    public boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    public void setFilter(String name, Filter filter) {
        this.filters.put(name, filter);
    }

    public void removeFilter(String name) {
        this.filters.remove(name);
    }

    public Map<String, Filter> getFilters() {
        return this.filters;
    }

    public void setFilters(Map<String, Filter> filters) {
        this.filters = filters;
    }

    public Map<String, Object> getSharedVariables() {
        return this.sharedVariables;
    }

    public void setSharedVariables(Map<String, Object> sharedVariables) {
        this.sharedVariables = sharedVariables;
    }

    public TemplateLoader getTemplateLoader() {
        return this.templateLoader;
    }

    public void setTemplateLoader(TemplateLoader templateLoader) {
        this.templateLoader = templateLoader;
    }

    public void setExpressionHandler(ExpressionHandler expressionHandler) {
        this.expressionHandler = expressionHandler;
    }

    public ExpressionHandler getExpressionHandler() {
        return this.expressionHandler;
    }

    public Jade4J.Mode getMode() {
        return this.mode;
    }

    public void setMode(Jade4J.Mode mode) {
        this.mode = mode;
    }

    public boolean templateExists(String url) {
        try {
            return this.templateLoader.getReader(url) != null;
        }
        catch (IOException e) {
            return false;
        }
    }

    public boolean isCaching() {
        return this.caching;
    }

    public void setCaching(boolean cache) {
        if (cache != this.caching) {
            this.expressionHandler.setCache(cache);
            this.caching = cache;
        }
    }

    public void clearCache() {
        this.expressionHandler.clearCache();
        this.cache.clear();
    }
}

