/*
 * Decompiled with CFR 0.152.
 */
package de.jjohannes.maven.gmm.checksums;

import de.jjohannes.maven.gmm.checksums.HashValue;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class HashUtil {
    public static HashValue createHash(File file, String algorithm) {
        try {
            return HashUtil.createHash(new FileInputStream(file), algorithm);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashValue createHash(InputStream instr, String algorithm) {
        MessageDigest messageDigest;
        try {
            messageDigest = HashUtil.createMessageDigest(algorithm);
            byte[] buffer = new byte[4096];
            try {
                int nread;
                while ((nread = instr.read(buffer)) >= 0) {
                    messageDigest.update(buffer, 0, nread);
                }
            }
            finally {
                instr.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new HashValue(messageDigest.digest());
    }

    private static MessageDigest createMessageDigest(String algorithm) {
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static HashValue sha1(File file) {
        return HashUtil.createHash(file, "SHA1");
    }

    public static HashValue sha256(File file) {
        return HashUtil.createHash(file, "SHA-256");
    }

    public static HashValue sha512(File file) {
        return HashUtil.createHash(file, "SHA-512");
    }
}

