/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.kryoserializers.guava;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Maps;
import java.util.EnumMap;
import java.util.Map;
import java.util.TreeMap;

public class ImmutableSortedMapSerializer
extends Serializer<ImmutableSortedMap<Object, ? extends Object>> {
    private static final boolean DOES_NOT_ACCEPT_NULL = true;
    private static final boolean IMMUTABLE = true;

    public ImmutableSortedMapSerializer() {
        super(true, true);
    }

    public void write(Kryo kryo, Output output, ImmutableSortedMap<Object, ? extends Object> immutableMap) {
        kryo.writeObject(output, (Object)Maps.newTreeMap(immutableMap));
    }

    public ImmutableSortedMap<Object, Object> read(Kryo kryo, Input input, Class<ImmutableSortedMap<Object, ? extends Object>> type) {
        Map map = (Map)kryo.readObject(input, TreeMap.class);
        return ImmutableSortedMap.copyOf((Map)map);
    }

    public static void registerSerializers(Kryo kryo) {
        ImmutableSortedMapSerializer serializer = new ImmutableSortedMapSerializer();
        kryo.register(ImmutableSortedMap.class, (Serializer)serializer);
        kryo.register(ImmutableSortedMap.of().getClass(), (Serializer)serializer);
        Comparable<Object> k1 = new Comparable<Object>(){

            @Override
            public int compareTo(Object o) {
                return o == this ? 0 : -1;
            }
        };
        Comparable<Object> k2 = new Comparable<Object>(){

            @Override
            public int compareTo(Object o) {
                return o == this ? 0 : 1;
            }
        };
        Object v1 = new Object();
        Object v2 = new Object();
        kryo.register(ImmutableSortedMap.of((Comparable)k1, (Object)v1).getClass(), (Serializer)serializer);
        kryo.register(ImmutableSortedMap.of((Comparable)k1, (Object)v1, (Comparable)k2, (Object)v2).getClass(), (Serializer)serializer);
        EnumMap<DummyEnum, Object> enumMap = new EnumMap<DummyEnum, Object>(DummyEnum.class);
        for (DummyEnum e : DummyEnum.values()) {
            enumMap.put(e, v1);
        }
        kryo.register(ImmutableSortedMap.copyOf(enumMap).getClass(), (Serializer)serializer);
    }

    private static enum DummyEnum {
        VALUE1,
        VALUE2;

    }
}

