/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.sender;

import de.huxhorn.lilith.sender.ConnectionState;
import de.huxhorn.lilith.sender.DataOutputStreamFactory;
import de.huxhorn.lilith.sender.SendBytesService;
import de.huxhorn.lilith.sender.WriteByteStrategy;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public class SimpleSendBytesService
implements SendBytesService {
    public static final int DEFAULT_RECONNECTION_DELAY = 30000;
    public static final int DEFAULT_QUEUE_SIZE = 1000;
    public static final int DEFAULT_POLL_INTERVAL = 100;
    private final Object lock = new Object();
    private final DataOutputStreamFactory dataOutputStreamFactory;
    private final WriteByteStrategy writeByteStrategy;
    private final int queueSize;
    private final long reconnectionDelay;
    private final int pollInterval;
    private final BlockingQueue<byte[]> localEventBytes;
    private final AtomicReference<ConnectionState> connectionState = new AtomicReference<ConnectionState>(ConnectionState.OFFLINE);
    private final AtomicBoolean shutdownIndicator = new AtomicBoolean(false);
    private SendBytesThread sendBytesThread;
    private boolean debug;

    public SimpleSendBytesService(DataOutputStreamFactory dataOutputStreamFactory, WriteByteStrategy writeByteStrategy) {
        this(dataOutputStreamFactory, writeByteStrategy, 1000, 30000L, 100);
    }

    public SimpleSendBytesService(DataOutputStreamFactory dataOutputStreamFactory, WriteByteStrategy writeByteStrategy, int queueSize, long reconnectionDelay, int pollInterval) {
        this.dataOutputStreamFactory = Objects.requireNonNull(dataOutputStreamFactory, "dataOutputStreamFactory must not be null!");
        this.writeByteStrategy = Objects.requireNonNull(writeByteStrategy, "writeByteStrategy must not be null!");
        if (queueSize <= 0) {
            throw new IllegalArgumentException("queueSize must be greater than zero but was " + queueSize + "!");
        }
        this.queueSize = queueSize;
        if (reconnectionDelay <= 0L) {
            throw new IllegalArgumentException("reconnectionDelay must be greater than zero but was " + reconnectionDelay + "!");
        }
        this.reconnectionDelay = reconnectionDelay;
        if (pollInterval <= 0) {
            throw new IllegalArgumentException("pollInterval must be greater than zero but was " + pollInterval + "!");
        }
        this.pollInterval = pollInterval;
        this.localEventBytes = new ArrayBlockingQueue<byte[]>(queueSize, true);
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public ConnectionState getConnectionState() {
        return this.connectionState.get();
    }

    @Override
    public void sendBytes(byte[] bytes) {
        if (this.connectionState.get() == ConnectionState.CONNECTED && this.sendBytesThread != null && bytes != null) {
            try {
                this.localEventBytes.put(bytes);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startUp() {
        Object object = this.lock;
        synchronized (object) {
            if (this.sendBytesThread == null) {
                this.shutdownIndicator.set(false);
                this.sendBytesThread = new SendBytesThread();
                this.sendBytesThread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutDown() {
        this.shutdownIndicator.set(true);
        Object object = this.lock;
        synchronized (object) {
            this.connectionState.set(ConnectionState.CANCELED);
        }
        if (this.sendBytesThread != null) {
            this.sendBytesThread.interrupt();
            try {
                this.sendBytesThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.sendBytesThread = null;
        }
        this.localEventBytes.clear();
    }

    private class SendBytesThread
    extends Thread {
        private DataOutputStream dataOutputStream;

        SendBytesThread() {
            super("SendBytes@" + SimpleSendBytesService.this.dataOutputStreamFactory);
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void closeConnection() {
            Object object = SimpleSendBytesService.this.lock;
            synchronized (object) {
                if (this.dataOutputStream != null) {
                    try {
                        this.dataOutputStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    this.dataOutputStream = null;
                    if (SimpleSendBytesService.this.connectionState.get() != ConnectionState.CANCELED) {
                        SimpleSendBytesService.this.connectionState.set(ConnectionState.OFFLINE);
                    }
                    if (SimpleSendBytesService.this.debug) {
                        System.err.println("Closed dataOutputStream.");
                    }
                }
                SimpleSendBytesService.this.lock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ReconnectionThread reconnectionThread = new ReconnectionThread();
            reconnectionThread.start();
            ArrayList copy = new ArrayList(SimpleSendBytesService.this.queueSize);
            try {
                while (true) {
                    SimpleSendBytesService.this.localEventBytes.drainTo(copy);
                    if (!copy.isEmpty()) {
                        DataOutputStream outputStream;
                        Iterator iterator = SimpleSendBytesService.this.lock;
                        synchronized (iterator) {
                            outputStream = this.dataOutputStream;
                        }
                        if (outputStream != null) {
                            try {
                                for (byte[] current : copy) {
                                    SimpleSendBytesService.this.writeByteStrategy.writeBytes(outputStream, current);
                                }
                                outputStream.flush();
                            }
                            catch (Throwable e) {
                                this.closeConnection();
                            }
                        }
                        copy.clear();
                    }
                    if (!SimpleSendBytesService.this.shutdownIndicator.get()) {
                        Thread.sleep(SimpleSendBytesService.this.pollInterval);
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            reconnectionThread.interrupt();
            try {
                reconnectionThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.closeConnection();
        }

        private class ReconnectionThread
        extends Thread {
            ReconnectionThread() {
                super("Reconnection@" + SimpleSendBytesService.this.dataOutputStreamFactory);
                this.setDaemon(true);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (true) {
                    boolean connect = false;
                    Object object = SimpleSendBytesService.this.lock;
                    synchronized (object) {
                        if (SendBytesThread.this.dataOutputStream == null && SimpleSendBytesService.this.connectionState.get() != ConnectionState.CANCELED) {
                            connect = true;
                            SimpleSendBytesService.this.connectionState.set(ConnectionState.CONNECTING);
                        }
                    }
                    DataOutputStream newStream = null;
                    if (connect) {
                        try {
                            newStream = SimpleSendBytesService.this.dataOutputStreamFactory.createDataOutputStream();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    Object object2 = SimpleSendBytesService.this.lock;
                    synchronized (object2) {
                        if (connect) {
                            if (newStream != null) {
                                if (SimpleSendBytesService.this.connectionState.get() == ConnectionState.CANCELED) {
                                    try {
                                        newStream.close();
                                    }
                                    catch (IOException iOException) {}
                                } else {
                                    SendBytesThread.this.dataOutputStream = newStream;
                                    SimpleSendBytesService.this.connectionState.set(ConnectionState.CONNECTED);
                                }
                            } else if (SimpleSendBytesService.this.connectionState.get() != ConnectionState.CANCELED) {
                                SimpleSendBytesService.this.connectionState.set(ConnectionState.OFFLINE);
                            }
                        }
                        try {
                            SimpleSendBytesService.this.lock.wait(SimpleSendBytesService.this.reconnectionDelay);
                        }
                        catch (InterruptedException e) {
                            return;
                        }
                    }
                }
            }
        }
    }
}

