/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.sender;

import de.huxhorn.lilith.sender.SendBytesService;
import de.huxhorn.lilith.sender.SimpleSendBytesService;
import de.huxhorn.lilith.sender.SocketDataOutputStreamFactory;
import de.huxhorn.lilith.sender.WriteByteStrategy;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;

public class MultiplexSendBytesService
implements SendBytesService {
    private final String name;
    private final List<String> remoteHostsList;
    private final int port;
    private final WriteByteStrategy writeByteStrategy;
    private final long reconnectionDelay;
    private final int queueSize;
    private final Set<SimpleSendBytesService> senderServices;
    private final BlockingQueue<byte[]> eventBytes;
    private Thread dispatcherThread;
    private boolean debug;

    public MultiplexSendBytesService(String name, List<String> remoteHostsList, int port, WriteByteStrategy writeByteStrategy, long reconnectionDelay, int queueSize) {
        this.name = name;
        this.remoteHostsList = Objects.requireNonNull(remoteHostsList, "remoteHostsList must not be null!");
        this.port = port;
        this.writeByteStrategy = Objects.requireNonNull(writeByteStrategy, "writeByteStrategy must not be null!");
        this.reconnectionDelay = reconnectionDelay;
        this.queueSize = queueSize;
        this.senderServices = new HashSet<SimpleSendBytesService>();
        this.eventBytes = new ArrayBlockingQueue<byte[]>(queueSize, true);
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    @Override
    public void startUp() {
        if (this.dispatcherThread == null) {
            for (String hostName : this.remoteHostsList) {
                SimpleSendBytesService service = this.createService(hostName);
                this.senderServices.add(service);
                service.startUp();
            }
            this.dispatcherThread = new Thread((Runnable)new DispatcherRunnable(), this.name + " Dispatcher");
            this.dispatcherThread.setDaemon(true);
            this.dispatcherThread.start();
        }
    }

    private SimpleSendBytesService createService(String hostName) {
        SocketDataOutputStreamFactory dataOutputStreamFactory = new SocketDataOutputStreamFactory(hostName, this.port);
        SimpleSendBytesService service = new SimpleSendBytesService(dataOutputStreamFactory, this.writeByteStrategy, this.queueSize, this.reconnectionDelay, 100);
        service.setDebug(this.debug);
        return service;
    }

    @Override
    public void shutDown() {
        if (this.dispatcherThread != null) {
            this.dispatcherThread.interrupt();
            for (SimpleSendBytesService current : this.senderServices) {
                current.shutDown();
            }
            this.senderServices.clear();
            this.eventBytes.clear();
            try {
                this.dispatcherThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.dispatcherThread = null;
        }
    }

    @Override
    public void sendBytes(byte[] serialized) {
        try {
            this.eventBytes.put(serialized);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private class DispatcherRunnable
    implements Runnable {
        private DispatcherRunnable() {
        }

        @Override
        public void run() {
            try {
                block2: while (true) {
                    byte[] bytes = (byte[])MultiplexSendBytesService.this.eventBytes.take();
                    Iterator iterator = MultiplexSendBytesService.this.senderServices.iterator();
                    while (true) {
                        if (!iterator.hasNext()) continue block2;
                        SimpleSendBytesService current = (SimpleSendBytesService)iterator.next();
                        current.sendBytes(bytes);
                    }
                    break;
                }
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }
}

