/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.data.logging;

import de.huxhorn.lilith.data.logging.ExtendedStackTraceElement;
import java.io.Serializable;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.Objects;

public class ThrowableInfo
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -6320441996003349426L;
    public static final String CAUSED_BY_PREFIX = "Caused by: ";
    public static final String SUPPRESSED_PREFIX = "Suppressed: ";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final ThrowableInfo[] ARRAY_PROTOTYPE = new ThrowableInfo[0];
    private String name;
    private String message;
    private ExtendedStackTraceElement[] stackTrace;
    private int omittedElements;
    private ThrowableInfo[] suppressed;
    private ThrowableInfo cause;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public ExtendedStackTraceElement[] getStackTrace() {
        return this.stackTrace;
    }

    public void setStackTrace(ExtendedStackTraceElement[] stackTrace) {
        this.stackTrace = stackTrace;
    }

    public ThrowableInfo[] getSuppressed() {
        return this.suppressed;
    }

    public void setSuppressed(ThrowableInfo[] suppressed) {
        this.suppressed = suppressed;
    }

    public ThrowableInfo getCause() {
        return this.cause;
    }

    public void setCause(ThrowableInfo cause) {
        this.cause = cause;
    }

    public int getOmittedElements() {
        return this.omittedElements;
    }

    public void setOmittedElements(int omittedElements) {
        this.omittedElements = omittedElements;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.recursiveEquals((ThrowableInfo)o, new IdentityHashMap<ThrowableInfo, Object>());
    }

    private boolean recursiveEquals(ThrowableInfo that, IdentityHashMap<ThrowableInfo, Object> dejaVu) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (dejaVu.containsKey(that)) {
            return true;
        }
        dejaVu.put(that, null);
        if (this.omittedElements != that.omittedElements) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.message != null ? !this.message.equals(that.message) : that.message != null) {
            return false;
        }
        if (!Arrays.equals(this.stackTrace, that.stackTrace)) {
            return false;
        }
        if (this.cause == null ? that.cause != null : !this.cause.recursiveEquals(that.cause, dejaVu)) {
            return false;
        }
        if (this.suppressed == null) {
            if (that.suppressed != null) {
                return false;
            }
        } else {
            if (that.suppressed == null) {
                return false;
            }
            if (this.suppressed.length != that.suppressed.length) {
                return false;
            }
            for (int i = 0; i < this.suppressed.length; ++i) {
                ThrowableInfo thisSuppressedEntry = this.suppressed[i];
                ThrowableInfo thatSuppressedEntry = that.suppressed[i];
                if (!(thisSuppressedEntry == null ? thatSuppressedEntry != null : !thisSuppressedEntry.recursiveEquals(thatSuppressedEntry, dejaVu))) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        return ThrowableInfo.recursiveHashCode(this, new IdentityHashMap<ThrowableInfo, Object>());
    }

    private static int recursiveHashCode(ThrowableInfo instance, IdentityHashMap<ThrowableInfo, Object> dejaVu) {
        if (instance == null) {
            return 0;
        }
        if (dejaVu.containsKey(instance)) {
            return 0;
        }
        dejaVu.put(instance, null);
        int result = instance.getOmittedElements();
        String name = instance.getName();
        result = 29 * result + (name != null ? name.hashCode() : 0);
        String message = instance.getMessage();
        result = 29 * result + (message != null ? message.hashCode() : 0);
        ThrowableInfo cause = instance.getCause();
        result = 29 * result + ThrowableInfo.recursiveHashCode(cause, dejaVu);
        ThrowableInfo[] suppressed = instance.getSuppressed();
        if (suppressed != null) {
            for (ThrowableInfo throwableInfo : suppressed) {
                result = 29 * result + ThrowableInfo.recursiveHashCode(throwableInfo, dejaVu);
            }
        }
        return result;
    }

    public ThrowableInfo clone() throws CloneNotSupportedException {
        return this.recursiveClone(new IdentityHashMap<ThrowableInfo, ThrowableInfo>());
    }

    private ThrowableInfo recursiveClone(IdentityHashMap<ThrowableInfo, ThrowableInfo> dejaVu) throws CloneNotSupportedException {
        Cloneable current;
        int i;
        ThrowableInfo result = dejaVu.get(this);
        if (result != null) {
            return result;
        }
        result = (ThrowableInfo)super.clone();
        dejaVu.put(this, result);
        if (this.stackTrace != null) {
            result.stackTrace = new ExtendedStackTraceElement[this.stackTrace.length];
            for (i = 0; i < this.stackTrace.length; ++i) {
                current = this.stackTrace[i];
                if (current == null) continue;
                result.stackTrace[i] = ((ExtendedStackTraceElement)current).clone();
            }
        }
        if (this.cause != null) {
            result.cause = this.cause.recursiveClone(dejaVu);
        }
        if (this.suppressed != null) {
            result.suppressed = new ThrowableInfo[this.suppressed.length];
            for (i = 0; i < this.suppressed.length; ++i) {
                current = this.suppressed[i];
                if (current == null) continue;
                result.suppressed[i] = super.recursiveClone(dejaVu);
            }
        }
        return result;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean extended) {
        return this.appendTo(new StringBuilder(), extended).toString();
    }

    public StringBuilder appendTo(StringBuilder stringBuilder, boolean extended) {
        Objects.requireNonNull(stringBuilder, "stringBuilder must not be null!");
        ThrowableInfo.recursiveAppend(stringBuilder, new IdentityHashMap<ThrowableInfo, Object>(), null, 0, this, extended);
        return stringBuilder;
    }

    private static void recursiveAppend(StringBuilder sb, IdentityHashMap<ThrowableInfo, Object> dejaVu, String prefix, int indent, ThrowableInfo throwableInfo, boolean extended) {
        String name;
        if (throwableInfo == null) {
            return;
        }
        ThrowableInfo.appendIndent(sb, indent);
        if (prefix != null) {
            sb.append(prefix);
        }
        if ((name = throwableInfo.getName()) != null) {
            sb.append(name);
            String message = throwableInfo.getMessage();
            if (message != null && !name.equals(message)) {
                sb.append(": ").append(throwableInfo.getMessage());
            }
        } else {
            sb.append(throwableInfo.getMessage());
        }
        if (dejaVu.containsKey(throwableInfo)) {
            sb.append("[CIRCULAR REFERENCE]\n");
            return;
        }
        dejaVu.put(throwableInfo, null);
        sb.append(LINE_SEPARATOR);
        ThrowableInfo.appendSTEArray(sb, indent + 1, throwableInfo, extended);
        ThrowableInfo[] suppressed = throwableInfo.getSuppressed();
        if (suppressed != null) {
            for (ThrowableInfo current : suppressed) {
                ThrowableInfo.recursiveAppend(sb, dejaVu, SUPPRESSED_PREFIX, indent + 1, current, extended);
            }
        }
        ThrowableInfo.recursiveAppend(sb, dejaVu, CAUSED_BY_PREFIX, indent, throwableInfo.getCause(), extended);
    }

    private static void appendIndent(StringBuilder sb, int indent) {
        for (int i = 0; i < indent; ++i) {
            sb.append('\t');
        }
    }

    private static void appendSTEArray(StringBuilder sb, int indentLevel, ThrowableInfo throwableInfo, boolean extended) {
        int commonFrames;
        ExtendedStackTraceElement[] steArray = throwableInfo.getStackTrace();
        if (steArray != null) {
            for (ExtendedStackTraceElement ste : steArray) {
                if (ste == null) continue;
                ThrowableInfo.appendIndent(sb, indentLevel);
                sb.append("at ");
                ste.appendTo(sb, extended);
                sb.append(LINE_SEPARATOR);
            }
        }
        if ((commonFrames = throwableInfo.getOmittedElements()) > 0) {
            ThrowableInfo.appendIndent(sb, indentLevel);
            sb.append("... ").append(commonFrames).append(" more").append(LINE_SEPARATOR);
        }
    }
}

