/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.data.logging;

import de.huxhorn.lilith.data.logging.MessageFormatter;
import java.io.Serializable;
import java.util.Arrays;

public final class Message
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 5086167676879398378L;
    public static final Message[] ARRAY_PROTOTYPE = new Message[0];
    private String messagePattern;
    private String[] arguments;
    private transient String formattedMessage;

    public Message() {
    }

    public Message(String messagePattern) {
        this(messagePattern, null);
    }

    public Message(String messagePattern, String[] arguments) {
        this.messagePattern = messagePattern;
        this.arguments = arguments;
    }

    public String getMessage() {
        if (this.formattedMessage == null) {
            this.formattedMessage = MessageFormatter.format(this.messagePattern, this.arguments);
        }
        return this.formattedMessage;
    }

    public String getMessagePattern() {
        return this.messagePattern;
    }

    public void setMessagePattern(String messagePattern) {
        this.messagePattern = messagePattern;
        this.formattedMessage = null;
    }

    public String[] getArguments() {
        return this.arguments;
    }

    public void setArguments(String[] arguments) {
        this.arguments = arguments;
        this.formattedMessage = null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Message message = (Message)o;
        return (this.messagePattern != null ? this.messagePattern.equals(message.messagePattern) : message.messagePattern == null) && Arrays.equals(this.arguments, message.arguments);
    }

    public int hashCode() {
        int result = this.messagePattern != null ? this.messagePattern.hashCode() : 0;
        result = 31 * result + (this.arguments != null ? Arrays.hashCode(this.arguments) : 0);
        return result;
    }

    public Message clone() throws CloneNotSupportedException {
        Message result = (Message)super.clone();
        if (this.arguments != null) {
            int len = this.arguments.length;
            result.arguments = new String[len];
            System.arraycopy(this.arguments, 0, result.arguments, 0, len);
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(200);
        sb.append("Message{messagePattern=");
        if (this.messagePattern == null) {
            sb.append((String)null);
        } else {
            sb.append('\"').append(this.messagePattern).append('\"');
        }
        sb.append(", arguments=");
        if (this.arguments == null) {
            sb.append((String)null);
        } else {
            sb.append('[');
            boolean first = true;
            for (String current : this.arguments) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                if (current == null) {
                    sb.append("null");
                    continue;
                }
                sb.append('\"').append(current).append('\"');
            }
            sb.append(']');
        }
        sb.append('}');
        return sb.toString();
    }
}

