/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.data.logging.protobuf;

import com.google.protobuf.InvalidProtocolBufferException;
import de.huxhorn.lilith.data.eventsource.EventIdentifier;
import de.huxhorn.lilith.data.eventsource.EventWrapper;
import de.huxhorn.lilith.data.eventsource.SourceIdentifier;
import de.huxhorn.lilith.data.logging.LoggingEvent;
import de.huxhorn.lilith.data.logging.protobuf.LoggingEventProtobufDecoder;
import de.huxhorn.lilith.data.logging.protobuf.generated.LoggingProto;
import de.huxhorn.sulky.codec.Decoder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.zip.GZIPInputStream;

class LoggingEventWrapperProtobufDecoder
implements Decoder<EventWrapper<LoggingEvent>> {
    private final boolean compressing;

    LoggingEventWrapperProtobufDecoder(boolean compressing) {
        this.compressing = compressing;
    }

    public boolean isCompressing() {
        return this.compressing;
    }

    public EventWrapper<LoggingEvent> decode(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        LoggingProto.EventWrapper parsedEvent = null;
        if (!this.compressing) {
            try {
                parsedEvent = LoggingProto.EventWrapper.parseFrom(bytes);
            }
            catch (InvalidProtocolBufferException invalidProtocolBufferException) {}
        } else {
            try (ByteArrayInputStream in = new ByteArrayInputStream(bytes);
                 GZIPInputStream gis = new GZIPInputStream(in);){
                parsedEvent = LoggingProto.EventWrapper.parseFrom(gis);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return LoggingEventWrapperProtobufDecoder.convert(parsedEvent);
    }

    public static EventWrapper<LoggingEvent> convert(LoggingProto.EventWrapper parsedEvent) {
        if (parsedEvent == null) {
            return null;
        }
        EventWrapper result = new EventWrapper();
        if (parsedEvent.hasEventIdentifier()) {
            result.setEventIdentifier(LoggingEventWrapperProtobufDecoder.convert(parsedEvent.getEventIdentifier()));
        }
        if (parsedEvent.hasEvent()) {
            result.setEvent((Serializable)LoggingEventProtobufDecoder.convert(parsedEvent.getEvent()));
        }
        return result;
    }

    public static EventIdentifier convert(LoggingProto.EventIdentifier eventIdentifier) {
        if (eventIdentifier == null) {
            return null;
        }
        EventIdentifier result = new EventIdentifier();
        if (eventIdentifier.hasSourceIdentifier()) {
            result.setSourceIdentifier(LoggingEventWrapperProtobufDecoder.convert(eventIdentifier.getSourceIdentifier()));
        }
        if (eventIdentifier.hasLocalId()) {
            result.setLocalId(eventIdentifier.getLocalId());
        }
        return result;
    }

    public static SourceIdentifier convert(LoggingProto.SourceIdentifier sourceIdentifier) {
        if (sourceIdentifier == null) {
            return null;
        }
        SourceIdentifier result = new SourceIdentifier();
        if (sourceIdentifier.hasIdentifier()) {
            result.setIdentifier(sourceIdentifier.getIdentifier());
        }
        if (sourceIdentifier.hasSecondaryIdentifier()) {
            result.setSecondaryIdentifier(sourceIdentifier.getSecondaryIdentifier());
        }
        return result;
    }
}

