/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.data.logging.protobuf;

import de.huxhorn.lilith.data.eventsource.LoggerContext;
import de.huxhorn.lilith.data.logging.ExtendedStackTraceElement;
import de.huxhorn.lilith.data.logging.LoggingEvent;
import de.huxhorn.lilith.data.logging.Marker;
import de.huxhorn.lilith.data.logging.Message;
import de.huxhorn.lilith.data.logging.ThreadInfo;
import de.huxhorn.lilith.data.logging.ThrowableInfo;
import de.huxhorn.lilith.data.logging.protobuf.generated.LoggingProto;
import de.huxhorn.sulky.codec.Decoder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;

class LoggingEventProtobufDecoder
implements Decoder<LoggingEvent> {
    private final boolean compressing;

    LoggingEventProtobufDecoder(boolean compressing) {
        this.compressing = compressing;
    }

    public boolean isCompressing() {
        return this.compressing;
    }

    public LoggingEvent decode(byte[] bytes) {
        LoggingProto.LoggingEvent parsedEvent;
        block28: {
            if (bytes == null) {
                return null;
            }
            try {
                if (!this.compressing) {
                    parsedEvent = LoggingProto.LoggingEvent.parseFrom(bytes);
                    break block28;
                }
                try (ByteArrayInputStream in = new ByteArrayInputStream(bytes);
                     GZIPInputStream gis = new GZIPInputStream(in);){
                    parsedEvent = LoggingProto.LoggingEvent.parseFrom(gis);
                }
            }
            catch (IOException e) {
                parsedEvent = null;
            }
        }
        return LoggingEventProtobufDecoder.convert(parsedEvent);
    }

    public static Marker convert(LoggingProto.Marker marker) {
        if (marker == null) {
            return null;
        }
        HashMap<String, Marker> markers = new HashMap<String, Marker>();
        return LoggingEventProtobufDecoder.convert(marker, markers);
    }

    private static Marker convert(LoggingProto.Marker marker, Map<String, Marker> markers) {
        int refCount;
        String markerName = marker.getName();
        Marker result = markers.get(markerName);
        if (result == null) {
            result = new Marker();
            result.setName(markerName);
            markers.put(markerName, result);
        }
        if ((refCount = marker.getReferenceCount()) > 0) {
            List<LoggingProto.Marker> refList = marker.getReferenceList();
            for (LoggingProto.Marker current : refList) {
                result.add(LoggingEventProtobufDecoder.convert(current, markers));
            }
        }
        return result;
    }

    public static ExtendedStackTraceElement convert(LoggingProto.StackTraceElement ste) {
        if (ste == null) {
            return null;
        }
        ExtendedStackTraceElement result = new ExtendedStackTraceElement();
        if (ste.hasClassLoaderName()) {
            result.setClassLoaderName(ste.getClassLoaderName());
        }
        if (ste.hasModuleName()) {
            result.setModuleName(ste.getModuleName());
        }
        if (ste.hasModuleVersion()) {
            result.setModuleVersion(ste.getModuleVersion());
        }
        if (ste.hasMethodName()) {
            result.setMethodName(ste.getMethodName());
        }
        if (ste.hasClassName()) {
            result.setClassName(ste.getClassName());
        }
        if (ste.hasFileName()) {
            result.setFileName(ste.getFileName());
        }
        if (ste.hasLineNumber()) {
            result.setLineNumber(ste.getLineNumber());
        }
        if (ste.hasCodeLocation()) {
            result.setCodeLocation(ste.getCodeLocation());
        }
        if (ste.hasVersion()) {
            result.setVersion(ste.getVersion());
        }
        if (ste.hasExact()) {
            result.setExact(ste.getExact());
        }
        return result;
    }

    public static ThrowableInfo convert(LoggingProto.Throwable throwable) {
        int i;
        int count;
        if (throwable == null) {
            return null;
        }
        ThrowableInfo result = new ThrowableInfo();
        if (throwable.hasThrowableClass()) {
            result.setName(throwable.getThrowableClass());
        }
        if (throwable.hasMessage()) {
            result.setMessage(throwable.getMessage());
        }
        if (throwable.hasOmittedElements()) {
            result.setOmittedElements(throwable.getOmittedElements());
        }
        if ((count = throwable.getSuppressedCount()) > 0) {
            ThrowableInfo[] suppressed = new ThrowableInfo[count];
            List<LoggingProto.Throwable> suppressedList = throwable.getSuppressedList();
            for (i = 0; i < count; ++i) {
                suppressed[i] = LoggingEventProtobufDecoder.convert(suppressedList.get(i));
            }
            result.setSuppressed(suppressed);
        }
        if (throwable.hasCause()) {
            result.setCause(LoggingEventProtobufDecoder.convert(throwable.getCause()));
        }
        if ((count = throwable.getStackTraceElementCount()) > 0) {
            ExtendedStackTraceElement[] stackTrace = new ExtendedStackTraceElement[count];
            List<LoggingProto.StackTraceElement> stackTraceElementList = throwable.getStackTraceElementList();
            for (i = 0; i < count; ++i) {
                stackTrace[i] = LoggingEventProtobufDecoder.convert(stackTraceElementList.get(i));
            }
            result.setStackTrace(stackTrace);
        }
        return result;
    }

    public static Message convert(LoggingProto.Message parsedMessage) {
        int argumentCount;
        if (parsedMessage == null) {
            return null;
        }
        Message result = new Message();
        if (parsedMessage.hasMessagePattern()) {
            result.setMessagePattern(parsedMessage.getMessagePattern());
        }
        if ((argumentCount = parsedMessage.getArgumentCount()) > 0) {
            String[] arguments = new String[argumentCount];
            List<LoggingProto.MessageArgument> argumentList = parsedMessage.getArgumentList();
            for (int i = 0; i < argumentCount; ++i) {
                LoggingProto.MessageArgument current = argumentList.get(i);
                if (!current.hasValue()) continue;
                arguments[i] = current.getValue();
            }
            result.setArguments(arguments);
        }
        return result;
    }

    public static ThreadInfo convert(LoggingProto.ThreadInfo parsedThreadInfo) {
        if (parsedThreadInfo == null) {
            return null;
        }
        Long threadId = null;
        if (parsedThreadInfo.hasId()) {
            threadId = parsedThreadInfo.getId();
        }
        String threadName = null;
        if (parsedThreadInfo.hasName()) {
            threadName = parsedThreadInfo.getName();
        }
        Long threadGroupId = null;
        if (parsedThreadInfo.hasGroupId()) {
            threadGroupId = parsedThreadInfo.getGroupId();
        }
        String threadGroupName = null;
        if (parsedThreadInfo.hasGroupName()) {
            threadGroupName = parsedThreadInfo.getGroupName();
        }
        ThreadInfo result = new ThreadInfo(threadId, threadName, threadGroupId, threadGroupName);
        if (parsedThreadInfo.hasPriority()) {
            result.setPriority(Integer.valueOf(parsedThreadInfo.getPriority()));
        }
        return result;
    }

    public static LoggerContext convert(LoggingProto.LoggerContext loggerContext) {
        if (loggerContext == null) {
            return null;
        }
        LoggerContext result = new LoggerContext();
        if (loggerContext.hasName()) {
            result.setName(loggerContext.getName());
        }
        if (loggerContext.hasBirthTime()) {
            result.setBirthTime(Long.valueOf(loggerContext.getBirthTime()));
        }
        if (loggerContext.hasProperties()) {
            result.setProperties(LoggingEventProtobufDecoder.convert(loggerContext.getProperties()));
        }
        return result;
    }

    public static Map<String, String> convert(LoggingProto.StringMap stringMap) {
        if (stringMap == null) {
            return null;
        }
        if (stringMap.getEntryCount() > 0) {
            HashMap<String, String> result = new HashMap<String, String>();
            List<LoggingProto.StringMapEntry> mdcList = stringMap.getEntryList();
            for (LoggingProto.StringMapEntry current : mdcList) {
                String key = current.getKey();
                String value = null;
                if (current.hasValue()) {
                    value = current.getValue();
                }
                result.put(key, value);
            }
            return result;
        }
        return null;
    }

    public static LoggingEvent convert(LoggingProto.LoggingEvent parsedEvent) {
        LoggingProto.NestedDiagnosticContext parsedNdc;
        int entryCount;
        int count;
        if (parsedEvent == null) {
            return null;
        }
        LoggingEvent result = new LoggingEvent();
        if (parsedEvent.hasLoggerName()) {
            result.setLogger(parsedEvent.getLoggerName());
        }
        if (parsedEvent.hasSequenceNumber()) {
            result.setSequenceNumber(Long.valueOf(parsedEvent.getSequenceNumber()));
        }
        if (parsedEvent.hasThreadInfo()) {
            result.setThreadInfo(LoggingEventProtobufDecoder.convert(parsedEvent.getThreadInfo()));
        }
        if (parsedEvent.hasLevel()) {
            LoggingProto.Level level = parsedEvent.getLevel();
            switch (level) {
                case TRACE: {
                    result.setLevel(LoggingEvent.Level.TRACE);
                    break;
                }
                case DEBUG: {
                    result.setLevel(LoggingEvent.Level.DEBUG);
                    break;
                }
                case INFO: {
                    result.setLevel(LoggingEvent.Level.INFO);
                    break;
                }
                case WARN: {
                    result.setLevel(LoggingEvent.Level.WARN);
                    break;
                }
                default: {
                    result.setLevel(LoggingEvent.Level.ERROR);
                }
            }
        }
        if (parsedEvent.hasLoggerContext()) {
            result.setLoggerContext(LoggingEventProtobufDecoder.convert(parsedEvent.getLoggerContext()));
        }
        if (parsedEvent.hasThrowable()) {
            result.setThrowable(LoggingEventProtobufDecoder.convert(parsedEvent.getThrowable()));
        }
        if (parsedEvent.hasMarker()) {
            result.setMarker(LoggingEventProtobufDecoder.convert(parsedEvent.getMarker()));
        }
        if ((count = parsedEvent.getCallStackElementCount()) > 0) {
            List<LoggingProto.StackTraceElement> callStackElements = parsedEvent.getCallStackElementList();
            ExtendedStackTraceElement[] callStack = new ExtendedStackTraceElement[count];
            for (int i = 0; i < count; ++i) {
                LoggingProto.StackTraceElement current = callStackElements.get(i);
                callStack[i] = LoggingEventProtobufDecoder.convert(current);
            }
            result.setCallStack(callStack);
        }
        if (parsedEvent.hasTimeStamp()) {
            result.setTimeStamp(Long.valueOf(parsedEvent.getTimeStamp()));
        }
        if (parsedEvent.hasMessage()) {
            result.setMessage(LoggingEventProtobufDecoder.convert(parsedEvent.getMessage()));
        }
        if (parsedEvent.hasMappedDiagnosticContext()) {
            result.setMdc(LoggingEventProtobufDecoder.convert(parsedEvent.getMappedDiagnosticContext()));
        }
        if (parsedEvent.hasNestedDiagnosticContext() && (entryCount = (parsedNdc = parsedEvent.getNestedDiagnosticContext()).getEntryCount()) > 0) {
            List<LoggingProto.Message> entryList = parsedNdc.getEntryList();
            Message[] ndc = new Message[entryCount];
            for (int i = 0; i < entryCount; ++i) {
                ndc[i] = LoggingEventProtobufDecoder.convert(entryList.get(i));
            }
            result.setNdc(ndc);
        }
        return result;
    }
}

