package de.flapdoodle.reverse;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link TransitionMapping}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableTransitionMapping.builder()}.
 */
@Generated(from = "TransitionMapping", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableTransitionMapping<D> extends TransitionMapping<D> {
  private final String label;
  private final StateMapping<D> destination;
  private final List<StateMapping<?>> mappings;

  private ImmutableTransitionMapping(
      String label,
      StateMapping<D> destination,
      List<StateMapping<?>> mappings) {
    this.label = label;
    this.destination = destination;
    this.mappings = mappings;
  }

  /**
   * @return The value of the {@code label} attribute
   */
  @Override
  public String label() {
    return label;
  }

  /**
   * @return The value of the {@code destination} attribute
   */
  @Override
  public StateMapping<D> destination() {
    return destination;
  }

  /**
   * @return The value of the {@code mappings} attribute
   */
  @Override
  public List<StateMapping<?>> mappings() {
    return mappings;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TransitionMapping#label() label} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for label
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTransitionMapping<D> withLabel(String value) {
    String newValue = Objects.requireNonNull(value, "label");
    if (this.label.equals(newValue)) return this;
    return new ImmutableTransitionMapping<>(newValue, this.destination, this.mappings);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TransitionMapping#destination() destination} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for destination
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTransitionMapping<D> withDestination(StateMapping<D> value) {
    if (this.destination == value) return this;
    StateMapping<D> newValue = Objects.requireNonNull(value, "destination");
    return new ImmutableTransitionMapping<>(this.label, newValue, this.mappings);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link TransitionMapping#mappings() mappings}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  @SafeVarargs @SuppressWarnings("varargs")
  public final ImmutableTransitionMapping<D> withMappings(StateMapping<?>... elements) {
    List<StateMapping<?>> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableTransitionMapping<>(this.label, this.destination, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link TransitionMapping#mappings() mappings}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of mappings elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableTransitionMapping<D> withMappings(Iterable<? extends StateMapping<?>> elements) {
    if (this.mappings == elements) return this;
    List<StateMapping<?>> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableTransitionMapping<>(this.label, this.destination, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableTransitionMapping} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableTransitionMapping<?>
        && equalTo(0, (ImmutableTransitionMapping<?>) another);
  }

  private boolean equalTo(int synthetic, ImmutableTransitionMapping<?> another) {
    return label.equals(another.label)
        && destination.equals(another.destination)
        && mappings.equals(another.mappings);
  }

  /**
   * Computes a hash code from attributes: {@code label}, {@code destination}, {@code mappings}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + label.hashCode();
    h += (h << 5) + destination.hashCode();
    h += (h << 5) + mappings.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code TransitionMapping} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "TransitionMapping{"
        + "label=" + label
        + ", destination=" + destination
        + ", mappings=" + mappings
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link TransitionMapping} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <D> generic parameter D
   * @param instance The instance to copy
   * @return A copied immutable TransitionMapping instance
   */
  public static <D> ImmutableTransitionMapping<D> copyOf(TransitionMapping<D> instance) {
    if (instance instanceof ImmutableTransitionMapping<?>) {
      return (ImmutableTransitionMapping<D>) instance;
    }
    return ImmutableTransitionMapping.<D>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableTransitionMapping ImmutableTransitionMapping}.
   * <pre>
   * ImmutableTransitionMapping.&amp;lt;D&amp;gt;builder()
   *    .label(String) // required {@link TransitionMapping#label() label}
   *    .destination(de.flapdoodle.reverse.StateMapping&amp;lt;D&amp;gt;) // required {@link TransitionMapping#destination() destination}
   *    .addMappings|addAllMappings(de.flapdoodle.reverse.StateMapping&amp;lt;?&amp;gt;) // {@link TransitionMapping#mappings() mappings} elements
   *    .build();
   * </pre>
   * @param <D> generic parameter D
   * @param label {@code label} parameter
   * @param destination {@code destination} parameter
   * @return A new ImmutableTransitionMapping builder
   */
  public static <D> ImmutableTransitionMapping.Builder<D> builder(String label, StateMapping<D> destination) {
    return new ImmutableTransitionMapping.Builder<>(label, destination);
  }

  static <D> ImmutableTransitionMapping.Builder<D> builder() {
    return new ImmutableTransitionMapping.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutableTransitionMapping ImmutableTransitionMapping}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "TransitionMapping", generator = "Immutables")
  public static final class Builder<D> {
    private static final long INIT_BIT_LABEL = 0x1L;
    private static final long INIT_BIT_DESTINATION = 0x2L;
    private long initBits = 0x3L;

    private String label;
    private StateMapping<D> destination;
    private List<StateMapping<?>> mappings = new ArrayList<StateMapping<?>>();

    private Builder(String label, StateMapping<D> destination) {
      label(label);
      destination(destination);
    }

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code TransitionMapping} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<D> from(TransitionMapping<D> instance) {
      Objects.requireNonNull(instance, "instance");
      label(instance.label());
      destination(instance.destination());
      addAllMappings(instance.mappings());
      return this;
    }

    /**
     * Initializes the value for the {@link TransitionMapping#label() label} attribute.
     * @param label The value for label 
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder<D> label(String label) {
      this.label = Objects.requireNonNull(label, "label");
      initBits &= ~INIT_BIT_LABEL;
      return this;
    }

    /**
     * Initializes the value for the {@link TransitionMapping#destination() destination} attribute.
     * @param destination The value for destination 
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder<D> destination(StateMapping<D> destination) {
      this.destination = Objects.requireNonNull(destination, "destination");
      initBits &= ~INIT_BIT_DESTINATION;
      return this;
    }

    /**
     * Adds one element to {@link TransitionMapping#mappings() mappings} list.
     * @param element A mappings element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<D> addMappings(StateMapping<?> element) {
      this.mappings.add(Objects.requireNonNull(element, "mappings element"));
      return this;
    }

    /**
     * Adds elements to {@link TransitionMapping#mappings() mappings} list.
     * @param elements An array of mappings elements
     * @return {@code this} builder for use in a chained invocation
     */
    @SafeVarargs @SuppressWarnings("varargs")
    public final Builder<D> addMappings(StateMapping<?>... elements) {
      for (StateMapping<?> element : elements) {
        this.mappings.add(Objects.requireNonNull(element, "mappings element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link TransitionMapping#mappings() mappings} list.
     * @param elements An iterable of mappings elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<D> mappings(Iterable<? extends StateMapping<?>> elements) {
      this.mappings.clear();
      return addAllMappings(elements);
    }

    /**
     * Adds elements to {@link TransitionMapping#mappings() mappings} list.
     * @param elements An iterable of mappings elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<D> addAllMappings(Iterable<? extends StateMapping<?>> elements) {
      for (StateMapping<?> element : elements) {
        this.mappings.add(Objects.requireNonNull(element, "mappings element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableTransitionMapping ImmutableTransitionMapping}.
     * @return An immutable instance of TransitionMapping
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableTransitionMapping<D> build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableTransitionMapping<>(label, destination, createUnmodifiableList(true, mappings));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_LABEL) != 0) attributes.add("label");
      if ((initBits & INIT_BIT_DESTINATION) != 0) attributes.add("destination");
      return "Cannot build TransitionMapping, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
