package de.flapdoodle.reverse;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Transitions}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableTransitions.builder()}.
 */
@Generated(from = "Transitions", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableTransitions extends Transitions {
  private final List<Transition<?>> transitions;

  private ImmutableTransitions(List<Transition<?>> transitions) {
    this.transitions = transitions;
  }

  /**
   * @return The value of the {@code transitions} attribute
   */
  @Override
  public List<Transition<?>> transitions() {
    return transitions;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Transitions#transitions() transitions}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  @SafeVarargs @SuppressWarnings("varargs")
  public final ImmutableTransitions withTransitions(Transition<?>... elements) {
    List<Transition<?>> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return validate(new ImmutableTransitions(newValue));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Transitions#transitions() transitions}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of transitions elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableTransitions withTransitions(Iterable<? extends Transition<?>> elements) {
    if (this.transitions == elements) return this;
    List<Transition<?>> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return validate(new ImmutableTransitions(newValue));
  }

  /**
   * This instance is equal to all instances of {@code ImmutableTransitions} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableTransitions
        && equalTo((ImmutableTransitions) another);
  }

  private boolean equalTo(ImmutableTransitions another) {
    return transitions.equals(another.transitions);
  }

  /**
   * Computes a hash code from attributes: {@code transitions}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + transitions.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Transitions} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Transitions{"
        + "transitions=" + transitions
        + "}";
  }

  private static ImmutableTransitions validate(ImmutableTransitions instance) {
    instance.checkForCollisions();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link Transitions} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Transitions instance
   */
  public static ImmutableTransitions copyOf(Transitions instance) {
    if (instance instanceof ImmutableTransitions) {
      return (ImmutableTransitions) instance;
    }
    return ImmutableTransitions.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableTransitions ImmutableTransitions}.
   * <pre>
   * ImmutableTransitions.builder()
   *    .addTransitions|addAllTransitions(de.flapdoodle.reverse.Transition&amp;lt;?&amp;gt;) // {@link Transitions#transitions() transitions} elements
   *    .build();
   * </pre>
   * @return A new ImmutableTransitions builder
   */
  public static ImmutableTransitions.Builder builder() {
    return new ImmutableTransitions.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableTransitions ImmutableTransitions}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Transitions", generator = "Immutables")
  public static final class Builder {
    private List<Transition<?>> transitions = new ArrayList<Transition<?>>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Transitions} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Transitions instance) {
      Objects.requireNonNull(instance, "instance");
      addAllTransitions(instance.transitions());
      return this;
    }

    /**
     * Adds one element to {@link Transitions#transitions() transitions} list.
     * @param element A transitions element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addTransitions(Transition<?> element) {
      this.transitions.add(Objects.requireNonNull(element, "transitions element"));
      return this;
    }

    /**
     * Adds elements to {@link Transitions#transitions() transitions} list.
     * @param elements An array of transitions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @SafeVarargs @SuppressWarnings("varargs")
    public final Builder addTransitions(Transition<?>... elements) {
      for (Transition<?> element : elements) {
        this.transitions.add(Objects.requireNonNull(element, "transitions element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link Transitions#transitions() transitions} list.
     * @param elements An iterable of transitions elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder transitions(Iterable<? extends Transition<?>> elements) {
      this.transitions.clear();
      return addAllTransitions(elements);
    }

    /**
     * Adds elements to {@link Transitions#transitions() transitions} list.
     * @param elements An iterable of transitions elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllTransitions(Iterable<? extends Transition<?>> elements) {
      for (Transition<?> element : elements) {
        this.transitions.add(Objects.requireNonNull(element, "transitions element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableTransitions ImmutableTransitions}.
     * @return An immutable instance of Transitions
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableTransitions build() {
      return ImmutableTransitions.validate(new ImmutableTransitions(createUnmodifiableList(true, transitions)));
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
