/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.reflection;

import de.flapdoodle.checks.Preconditions;
import de.flapdoodle.reflection.ImmutableListTypeInfo;
import de.flapdoodle.reflection.TypeInfo;
import java.util.List;
import org.immutables.value.Value;

@Value.Immutable
public abstract class ListTypeInfo<T>
implements TypeInfo<List<T>> {
    @Value.Parameter
    public abstract TypeInfo<T> elements();

    @Override
    public List<T> cast(Object instance) {
        Preconditions.checkArgument(this.isInstance(instance), "type mismatch: %s is not a %s", instance, this);
        return (List)instance;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isInstance(Object instance) {
        if (!(instance instanceof List)) return false;
        if (!((List)instance).stream().allMatch(this.elements()::isInstance)) return false;
        return true;
    }

    static <T> ListTypeInfo<T> of(TypeInfo<T> type) {
        return ImmutableListTypeInfo.of(type);
    }
}

