/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.graph;

import de.flapdoodle.graph.GraphBuilder;
import de.flapdoodle.graph.ImmutableEdge;
import de.flapdoodle.graph.ImmutableLoop;
import de.flapdoodle.graph.ImmutableVerticesAndEdges;
import de.flapdoodle.graph.LazyGraphBuilder;
import de.flapdoodle.graph.Loop;
import de.flapdoodle.graph.VerticesAndEdges;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jgrapht.Graph;
import org.jgrapht.GraphPath;
import org.jgrapht.alg.connectivity.KosarajuStrongConnectivityInspector;
import org.jgrapht.alg.shortestpath.DijkstraShortestPath;
import org.jgrapht.graph.DefaultDirectedGraph;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.DirectedMultigraph;
import org.jgrapht.graph.DirectedPseudograph;

public class Graphs {
    public static <V, E> DefaultDirectedGraph<V, E> filter(DefaultDirectedGraph<V, E> src, Predicate<V> filter) {
        return Graphs.filter(src, filter, v -> {}, edge -> {});
    }

    public static <V, E> DefaultDirectedGraph<V, E> filter(DefaultDirectedGraph<V, E> src, Predicate<V> filter, Consumer<V> filteredVertexConsumer, Consumer<E> filteredEdgeConsumer) {
        DefaultDirectedGraph ret = new DefaultDirectedGraph(src.getVertexSupplier(), src.getEdgeSupplier(), src.getType().isWeighted());
        src.vertexSet().forEach(v -> {
            if (filter.test(v)) {
                ret.addVertex(v);
            } else {
                filteredVertexConsumer.accept(v);
            }
        });
        src.edgeSet().forEach(edge -> {
            Object source = src.getEdgeSource(edge);
            Object target = src.getEdgeTarget(edge);
            if (filter.test(source) && filter.test(target)) {
                ret.addEdge(source, target, edge);
            } else {
                filteredEdgeConsumer.accept(edge);
            }
        });
        return ret;
    }

    public static <V, E> Collection<VerticesAndEdges<V, E>> leavesOf(DefaultDirectedGraph<V, E> src) {
        return Graphs.leavesOrRootsOf(src, true);
    }

    public static <V, E> Collection<VerticesAndEdges<V, E>> rootsOf(DefaultDirectedGraph<V, E> src) {
        return Graphs.leavesOrRootsOf(src, false);
    }

    private static <V, E> Collection<VerticesAndEdges<V, E>> leavesOrRootsOf(DefaultDirectedGraph<V, E> src, boolean leafes) {
        ArrayList<VerticesAndEdges<Object, Object>> ret = new ArrayList<VerticesAndEdges<Object, Object>>();
        ImmutableVerticesAndEdges.Builder builder = ImmutableVerticesAndEdges.builder();
        DefaultDirectedGraph<Object, Object> filtered = Graphs.filter(src, leafes ? Graphs.isLeaf(src).negate() : Graphs.isRoot(src).negate(), t -> builder.addVertices(t), e -> builder.addEdges(ImmutableEdge.of(src.getEdgeSource(e), src.getEdgeTarget(e), e)));
        ImmutableVerticesAndEdges verticesAndEdges = builder.build();
        if (!verticesAndEdges.vertices().isEmpty()) {
            ret.add(verticesAndEdges);
            ret.addAll(Graphs.leavesOrRootsOf(filtered, leafes));
        } else {
            List<Graph<V, E>> loopingSubGraph = Graphs.loopsOfGraph(src);
            Set vertexInLoopSet = loopingSubGraph.stream().flatMap(g -> g.vertexSet().stream()).collect(Collectors.toSet());
            if (!loopingSubGraph.isEmpty()) {
                DefaultDirectedGraph<Object, Object> filteredFromLoops = Graphs.filter(filtered, v -> !vertexInLoopSet.contains(v), t -> {}, e -> {});
                ImmutableVerticesAndEdges<V, E> loopingVerticesAndEdges = Graphs.verticesAndEdgesOf(Graphs.loopsOf(loopingSubGraph));
                ret.add(loopingVerticesAndEdges);
                ret.addAll(Graphs.leavesOrRootsOf(filteredFromLoops, leafes));
            }
        }
        return Collections.unmodifiableCollection(ret);
    }

    private static <V, E> ImmutableVerticesAndEdges<V, E> verticesAndEdgesOf(List<? extends Loop<V, E>> loops) {
        ImmutableVerticesAndEdges.Builder loopingVerticesAndEdgesBuilder = ImmutableVerticesAndEdges.builder();
        loops.forEach(l -> loopingVerticesAndEdgesBuilder.addAllVertices(l.vertexSet()));
        loopingVerticesAndEdgesBuilder.addAllLoops(loops);
        return loopingVerticesAndEdgesBuilder.build();
    }

    private static <V, E> List<? extends Loop<V, E>> loopsOf(List<Graph<V, E>> loopingSubGraph) {
        ArrayList ret = new ArrayList();
        loopingSubGraph.forEach(g -> {
            ImmutableLoop.Builder loopBuilder = ImmutableLoop.builder();
            g.edgeSet().forEach(egde -> loopBuilder.addEdges(ImmutableEdge.of(g.getEdgeSource(egde), g.getEdgeTarget(egde), egde)));
            ret.add(loopBuilder.build());
        });
        return Collections.unmodifiableList(ret);
    }

    private static <V, E> List<Graph<V, E>> loopsOfGraph(DefaultDirectedGraph<V, E> src) {
        KosarajuStrongConnectivityInspector inspector = new KosarajuStrongConnectivityInspector(src);
        List loopingSubGraph = inspector.getStronglyConnectedComponents().stream().filter(l -> l.vertexSet().size() > 1 || l.containsEdge(l.vertexSet().iterator().next(), l.vertexSet().iterator().next())).collect(Collectors.toList());
        return Collections.unmodifiableList(loopingSubGraph);
    }

    public static <V, E> List<? extends Loop<V, E>> loopsOf(DefaultDirectedGraph<V, E> src) {
        return Graphs.loopsOf(Graphs.loopsOfGraph(src));
    }

    public static <V> Predicate<V> isLeaf(DefaultDirectedGraph<V, ?> graph) {
        return v -> graph.outDegreeOf(v) == 0;
    }

    public static <V> Predicate<V> isRoot(DefaultDirectedGraph<V, ?> graph) {
        return v -> graph.inDegreeOf(v) == 0;
    }

    public static <V> boolean hasPath(DefaultDirectedGraph<V, ?> graph, V from, V to) {
        GraphPath paths = DijkstraShortestPath.findPathBetween(graph, from, to);
        return paths != null && !paths.getEdgeList().isEmpty();
    }

    public static <V, E, G extends Graph<V, E>> LazyGraphBuilder<V, E, G> with(Supplier<GraphBuilder<V, E, G>> graphSupplier) {
        return new LazyGraphBuilder<V, E, G>(graphSupplier);
    }

    public static <V, E, G extends Graph<V, E>> Supplier<GraphBuilder<V, E, G>> graphBuilder(Supplier<G> graphSupplier) {
        return () -> GraphBuilder.of((Graph)graphSupplier.get());
    }

    public static <V> Supplier<GraphBuilder<V, DefaultEdge, DefaultDirectedGraph<V, DefaultEdge>>> directedGraphBuilder() {
        return () -> GraphBuilder.of(Graphs.directedGraph());
    }

    @Deprecated
    public static <V> Supplier<DefaultDirectedGraph<V, DefaultEdge>> directedGraphFactory() {
        return Directed::newInstance;
    }

    @Deprecated
    public static <V, E> Supplier<DefaultDirectedGraph<V, E>> directedGraphFactory(Class<? extends E> edgeClass) {
        return Directed.factory(edgeClass);
    }

    @Deprecated
    public static <V> DefaultDirectedGraph<V, DefaultEdge> directedGraph() {
        return Directed.newInstance(DefaultEdge.class);
    }

    @Deprecated
    public static <V, E> DefaultDirectedGraph<V, E> directedGraph(Class<? extends E> edgeClass) {
        return Directed.newInstance(edgeClass);
    }

    @Deprecated
    public static <V, E> Supplier<DefaultDirectedGraph<V, E>> directedGraphFactory(Class<V> vertexClass, Class<? extends E> edgeClass) {
        return Directed.factory(edgeClass);
    }

    @Deprecated
    public static <V, E> Supplier<DirectedMultigraph<V, DefaultEdge>> directedMultiEdgeGraphFactory() {
        return Multi.factory(DefaultEdge.class);
    }

    @Deprecated
    public static <V, E> Supplier<DirectedMultigraph<V, E>> directedMultiEdgeGraphFactory(Class<V> vertexClass, Class<? extends E> edgeClass) {
        return Multi.factory(edgeClass);
    }

    @Deprecated
    public static <V, E> Supplier<DirectedMultigraph<V, E>> directedMultiEdgeGraphFactory(Class<? extends E> edgeClass) {
        return Multi.factory(edgeClass);
    }

    @Deprecated
    private static <V> DirectedMultigraph<V, DefaultEdge> directedMultiEdgeGraph() {
        return Multi.newInstance(DefaultEdge.class);
    }

    @Deprecated
    private static <V, E> DirectedMultigraph<V, E> directedMultiEdgeGraph(Class<? extends E> edgeClass) {
        return Multi.newInstance(edgeClass);
    }

    @Deprecated
    public static <V, E> Supplier<DirectedPseudograph<V, DefaultEdge>> directedPseudoGraph() {
        return Pseudo.factory(DefaultEdge.class);
    }

    @Deprecated
    public static <V, E> Supplier<DirectedPseudograph<V, E>> directedPseudoGraph(Class<? extends E> edgeClass) {
        return Pseudo.factory(edgeClass);
    }

    @Deprecated
    public static <V, E> Supplier<DirectedPseudograph<V, E>> directedPseudoGraph(Class<V> vertexClass, Class<? extends E> edgeClass) {
        return Pseudo.factory(edgeClass);
    }

    public static abstract class Pseudo {
        public static <V, E> Supplier<DirectedPseudograph<V, E>> factory(Class<? extends E> edgeClass) {
            return () -> Pseudo.newInstance(edgeClass);
        }

        public static <V> DirectedPseudograph<V, DefaultEdge> newInstance() {
            return Pseudo.newInstance(DefaultEdge.class);
        }

        public static <V, E> DirectedPseudograph<V, E> newInstance(Class<? extends E> edgeClass) {
            return new DirectedPseudograph(edgeClass);
        }
    }

    public static abstract class Multi {
        public static <V, E> Supplier<DirectedMultigraph<V, E>> factory(Class<? extends E> edgeClass) {
            return () -> Multi.newInstance(edgeClass);
        }

        public static <V> DirectedMultigraph<V, DefaultEdge> newInstance() {
            return Multi.newInstance(DefaultEdge.class);
        }

        public static <V, E> DirectedMultigraph<V, E> newInstance(Class<? extends E> edgeClass) {
            return new DirectedMultigraph(edgeClass);
        }
    }

    public static abstract class Directed {
        public static <V, E> Supplier<DefaultDirectedGraph<V, E>> factory(Class<? extends E> edgeClass) {
            return () -> Directed.newInstance(edgeClass);
        }

        public static <V> DefaultDirectedGraph<V, DefaultEdge> newInstance() {
            return Directed.newInstance(DefaultEdge.class);
        }

        public static <V, E> DefaultDirectedGraph<V, E> newInstance(Class<? extends E> edgeClass) {
            return new DefaultDirectedGraph(edgeClass);
        }
    }
}

