/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.graph;

import de.flapdoodle.graph.Edge;
import de.flapdoodle.graph.Loop;
import de.flapdoodle.graph.VerticesAndEdges;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.immutables.value.Generated;

@Generated(from="VerticesAndEdges", generator="Immutables")
public final class ImmutableVerticesAndEdges<V, E>
implements VerticesAndEdges<V, E> {
    private final Set<V> vertices;
    private final Set<Edge<V, E>> edges;
    private final Set<Loop<V, E>> loops;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableVerticesAndEdges(Builder<V, E> builder) {
        this.vertices = ImmutableVerticesAndEdges.createUnmodifiableSet(((Builder)builder).vertices);
        if (((Builder)builder).edgesIsSet()) {
            this.initShim.edges(ImmutableVerticesAndEdges.createUnmodifiableSet(((Builder)builder).edges));
        }
        if (((Builder)builder).loopsIsSet()) {
            this.initShim.loops(ImmutableVerticesAndEdges.createUnmodifiableSet(((Builder)builder).loops));
        }
        this.edges = this.initShim.edges();
        this.loops = this.initShim.loops();
        this.initShim = null;
    }

    private ImmutableVerticesAndEdges(Set<V> vertices, Set<Edge<V, E>> edges, Set<Loop<V, E>> loops) {
        this.vertices = vertices;
        this.edges = edges;
        this.loops = loops;
        this.initShim = null;
    }

    private Set<Edge<V, E>> edgesInitialize() {
        return VerticesAndEdges.super.edges();
    }

    private Set<Loop<V, E>> loopsInitialize() {
        return VerticesAndEdges.super.loops();
    }

    @Override
    public Set<V> vertices() {
        return this.vertices;
    }

    @Override
    public Set<Edge<V, E>> edges() {
        InitShim shim = this.initShim;
        return shim != null ? shim.edges() : this.edges;
    }

    @Override
    public Set<Loop<V, E>> loops() {
        InitShim shim = this.initShim;
        return shim != null ? shim.loops() : this.loops;
    }

    @SafeVarargs
    public final ImmutableVerticesAndEdges<V, E> withVertices(V ... elements) {
        Set<V> newValue = ImmutableVerticesAndEdges.createUnmodifiableSet(ImmutableVerticesAndEdges.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableVerticesAndEdges.validate(new ImmutableVerticesAndEdges<V, E>(newValue, this.edges, this.loops));
    }

    public final ImmutableVerticesAndEdges<V, E> withVertices(Iterable<? extends V> elements) {
        if (this.vertices == elements) {
            return this;
        }
        Set<? extends V> newValue = ImmutableVerticesAndEdges.createUnmodifiableSet(ImmutableVerticesAndEdges.createSafeList(elements, true, false));
        return ImmutableVerticesAndEdges.validate(new ImmutableVerticesAndEdges<V, E>(newValue, this.edges, this.loops));
    }

    @SafeVarargs
    public final ImmutableVerticesAndEdges<V, E> withEdges(Edge<V, E> ... elements) {
        Set<Edge<V, E>> newValue = ImmutableVerticesAndEdges.createUnmodifiableSet(ImmutableVerticesAndEdges.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableVerticesAndEdges.validate(new ImmutableVerticesAndEdges<V, E>(this.vertices, newValue, this.loops));
    }

    public final ImmutableVerticesAndEdges<V, E> withEdges(Iterable<? extends Edge<V, E>> elements) {
        if (this.edges == elements) {
            return this;
        }
        Set<Edge<V, E>> newValue = ImmutableVerticesAndEdges.createUnmodifiableSet(ImmutableVerticesAndEdges.createSafeList(elements, true, false));
        return ImmutableVerticesAndEdges.validate(new ImmutableVerticesAndEdges<V, E>(this.vertices, newValue, this.loops));
    }

    @SafeVarargs
    public final ImmutableVerticesAndEdges<V, E> withLoops(Loop<V, E> ... elements) {
        Set<Loop<V, E>> newValue = ImmutableVerticesAndEdges.createUnmodifiableSet(ImmutableVerticesAndEdges.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableVerticesAndEdges.validate(new ImmutableVerticesAndEdges<V, E>(this.vertices, this.edges, newValue));
    }

    public final ImmutableVerticesAndEdges<V, E> withLoops(Iterable<? extends Loop<V, E>> elements) {
        if (this.loops == elements) {
            return this;
        }
        Set<Loop<V, E>> newValue = ImmutableVerticesAndEdges.createUnmodifiableSet(ImmutableVerticesAndEdges.createSafeList(elements, true, false));
        return ImmutableVerticesAndEdges.validate(new ImmutableVerticesAndEdges<V, E>(this.vertices, this.edges, newValue));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableVerticesAndEdges && this.equalTo((ImmutableVerticesAndEdges)another);
    }

    private boolean equalTo(ImmutableVerticesAndEdges<?, ?> another) {
        return this.vertices.equals(another.vertices) && this.edges.equals(another.edges) && this.loops.equals(another.loops);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.vertices.hashCode();
        h += (h << 5) + this.edges.hashCode();
        h += (h << 5) + this.loops.hashCode();
        return h;
    }

    public String toString() {
        return "VerticesAndEdges{vertices=" + this.vertices + ", edges=" + this.edges + ", loops=" + this.loops + "}";
    }

    private static <V, E> ImmutableVerticesAndEdges<V, E> validate(ImmutableVerticesAndEdges<V, E> instance) {
        instance.check();
        return instance;
    }

    public static <V, E> ImmutableVerticesAndEdges<V, E> copyOf(VerticesAndEdges<V, E> instance) {
        if (instance instanceof ImmutableVerticesAndEdges) {
            return (ImmutableVerticesAndEdges)instance;
        }
        return ImmutableVerticesAndEdges.builder().from(instance).build();
    }

    public static <V, E> Builder<V, E> builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> Set<T> createUnmodifiableSet(List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(list.get(0));
            }
        }
        LinkedHashSet<T> set = new LinkedHashSet<T>(list.size());
        set.addAll(list);
        return Collections.unmodifiableSet(set);
    }

    @Generated(from="VerticesAndEdges", generator="Immutables")
    public static final class Builder<V, E> {
        private static final long OPT_BIT_EDGES = 1L;
        private static final long OPT_BIT_LOOPS = 2L;
        private long optBits;
        private List<V> vertices = new ArrayList<V>();
        private List<Edge<V, E>> edges = new ArrayList<Edge<V, E>>();
        private List<Loop<V, E>> loops = new ArrayList<Loop<V, E>>();

        private Builder() {
        }

        public final Builder<V, E> from(VerticesAndEdges<V, E> instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllVertices(instance.vertices());
            this.addAllEdges(instance.edges());
            this.addAllLoops(instance.loops());
            return this;
        }

        public final Builder<V, E> addVertices(V element) {
            this.vertices.add(Objects.requireNonNull(element, "vertices element"));
            return this;
        }

        @SafeVarargs
        public final Builder<V, E> addVertices(V ... elements) {
            for (V element : elements) {
                this.vertices.add(Objects.requireNonNull(element, "vertices element"));
            }
            return this;
        }

        public final Builder<V, E> vertices(Iterable<? extends V> elements) {
            this.vertices.clear();
            return this.addAllVertices(elements);
        }

        public final Builder<V, E> addAllVertices(Iterable<? extends V> elements) {
            for (V element : elements) {
                this.vertices.add(Objects.requireNonNull(element, "vertices element"));
            }
            return this;
        }

        public final Builder<V, E> addEdges(Edge<V, E> element) {
            this.edges.add(Objects.requireNonNull(element, "edges element"));
            this.optBits |= 1L;
            return this;
        }

        @SafeVarargs
        public final Builder<V, E> addEdges(Edge<V, E> ... elements) {
            for (Edge<V, E> element : elements) {
                this.edges.add(Objects.requireNonNull(element, "edges element"));
            }
            this.optBits |= 1L;
            return this;
        }

        public final Builder<V, E> edges(Iterable<? extends Edge<V, E>> elements) {
            this.edges.clear();
            return this.addAllEdges(elements);
        }

        public final Builder<V, E> addAllEdges(Iterable<? extends Edge<V, E>> elements) {
            for (Edge<V, E> element : elements) {
                this.edges.add(Objects.requireNonNull(element, "edges element"));
            }
            this.optBits |= 1L;
            return this;
        }

        public final Builder<V, E> addLoops(Loop<V, E> element) {
            this.loops.add(Objects.requireNonNull(element, "loops element"));
            this.optBits |= 2L;
            return this;
        }

        @SafeVarargs
        public final Builder<V, E> addLoops(Loop<V, E> ... elements) {
            for (Loop<V, E> element : elements) {
                this.loops.add(Objects.requireNonNull(element, "loops element"));
            }
            this.optBits |= 2L;
            return this;
        }

        public final Builder<V, E> loops(Iterable<? extends Loop<V, E>> elements) {
            this.loops.clear();
            return this.addAllLoops(elements);
        }

        public final Builder<V, E> addAllLoops(Iterable<? extends Loop<V, E>> elements) {
            for (Loop<V, E> element : elements) {
                this.loops.add(Objects.requireNonNull(element, "loops element"));
            }
            this.optBits |= 2L;
            return this;
        }

        public ImmutableVerticesAndEdges<V, E> build() {
            return ImmutableVerticesAndEdges.validate(new ImmutableVerticesAndEdges(this));
        }

        private boolean edgesIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean loopsIsSet() {
            return (this.optBits & 2L) != 0L;
        }
    }

    @Generated(from="VerticesAndEdges", generator="Immutables")
    private final class InitShim {
        private byte edgesBuildStage = 0;
        private Set<Edge<V, E>> edges;
        private byte loopsBuildStage = 0;
        private Set<Loop<V, E>> loops;

        private InitShim() {
        }

        Set<Edge<V, E>> edges() {
            if (this.edgesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.edgesBuildStage == 0) {
                this.edgesBuildStage = (byte)-1;
                this.edges = ImmutableVerticesAndEdges.createUnmodifiableSet(ImmutableVerticesAndEdges.createSafeList(ImmutableVerticesAndEdges.this.edgesInitialize(), true, false));
                this.edgesBuildStage = 1;
            }
            return this.edges;
        }

        void edges(Set<Edge<V, E>> edges) {
            this.edges = edges;
            this.edgesBuildStage = 1;
        }

        Set<Loop<V, E>> loops() {
            if (this.loopsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.loopsBuildStage == 0) {
                this.loopsBuildStage = (byte)-1;
                this.loops = ImmutableVerticesAndEdges.createUnmodifiableSet(ImmutableVerticesAndEdges.createSafeList(ImmutableVerticesAndEdges.this.loopsInitialize(), true, false));
                this.loopsBuildStage = 1;
            }
            return this.loops;
        }

        void loops(Set<Loop<V, E>> loops) {
            this.loops = loops;
            this.loopsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.edgesBuildStage == -1) {
                attributes.add("edges");
            }
            if (this.loopsBuildStage == -1) {
                attributes.add("loops");
            }
            return "Cannot build VerticesAndEdges, attribute initializers form cycle " + attributes;
        }
    }
}

